/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;

public class EditJTI {
    private InterviewParameters interview;
    private boolean verbose;
    private PrintWriter out;
    private static int MAX_INDENT = Integer.getInteger("EditJTI.maxIndent", 32);
    private static int NUM_BACKUPS = Integer.getInteger("EditJTI.numBackups", 2);
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(EditJTI.class);

    public static void main(String[] args) {
        try {
            EditJTI e = new EditJTI();
            boolean ok = e.run(args);
            System.exit(ok ? 0 : 1);
        }
        catch (BadArgs e) {
            System.err.println(e.getMessage());
            EditJTI.usage(System.err);
            System.exit(2);
        }
        catch (Fault e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
    }

    public static void usage(PrintStream out) {
        String prog = System.getProperty("program", "java " + EditJTI.class.getName());
        out.println(i18n.getString("editJTI.usage.title"));
        out.print("  ");
        out.print(prog);
        out.println(i18n.getString("editJTI.usage.summary"));
        out.println(i18n.getString("editJTI.usage.options"));
        out.println(i18n.getString("editJTI.usage.help1"));
        out.println(i18n.getString("editJTI.usage.help2"));
        out.println(i18n.getString("editJTI.usage.help3"));
        out.println(i18n.getString("editJTI.usage.classpath1"));
        out.println(i18n.getString("editJTI.usage.classpath2"));
        out.println(i18n.getString("editJTI.usage.log1"));
        out.println(i18n.getString("editJTI.usage.log2"));
        out.println(i18n.getString("editJTI.usage.outfile1"));
        out.println(i18n.getString("editJTI.usage.outfile2"));
        out.println(i18n.getString("editJTI.usage.path1"));
        out.println(i18n.getString("editJTI.usage.path2"));
        out.println(i18n.getString("editJTI.usage.preview1"));
        out.println(i18n.getString("editJTI.usage.preview2"));
        out.println(i18n.getString("editJTI.usage.ts1"));
        out.println(i18n.getString("editJTI.usage.ts2"));
        out.println(i18n.getString("editJTI.usage.verbose1"));
        out.println(i18n.getString("editJTI.usage.verbose2"));
        out.println("");
        out.println(i18n.getString("editJTI.usage.edit"));
        out.println(i18n.getString("editJTI.usage.set"));
        out.println(i18n.getString("editJTI.usage.search"));
        out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(String[] args) throws BadArgs, Fault {
        PrintWriter out = new PrintWriter(System.out);
        try {
            boolean bl = this.run(args, out);
            return bl;
        }
        finally {
            out.flush();
        }
    }

    public boolean run(String[] args, PrintWriter out) throws BadArgs, Fault {
        boolean showPathFlag;
        boolean previewFlag;
        String[] editCmds;
        File logFile;
        File outFile;
        File inFile;
        block49: {
            inFile = null;
            outFile = null;
            logFile = null;
            File classPath = null;
            File testSuitePath = null;
            File workDirPath = null;
            editCmds = null;
            boolean helpFlag = false;
            previewFlag = false;
            showPathFlag = false;
            boolean verboseFlag = false;
            for (int i = 0; i < args.length; ++i) {
                if ((args[i].equals("-o") || args[i].equals("-out")) && i + 1 < args.length) {
                    EditJTI.checkUnset(outFile, args[i]);
                    outFile = new File(args[++i]);
                    continue;
                }
                if ((args[i].equals("-i") || args[i].equals("-in")) && i + 1 < args.length) {
                    EditJTI.checkUnset(inFile, args[i]);
                    inFile = new File(args[++i]);
                    continue;
                }
                if ((args[i].equals("-l") || args[i].equals("log")) && i + 1 < args.length) {
                    EditJTI.checkUnset(logFile, args[i]);
                    logFile = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-n") || args[i].equals("-preview")) {
                    previewFlag = true;
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("-path")) {
                    showPathFlag = true;
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("-verbose")) {
                    verboseFlag = true;
                    continue;
                }
                if ((args[i].equals("-cp") || args[i].equals("-classpath")) && i + 1 < args.length) {
                    EditJTI.checkUnset(classPath, args[i]);
                    classPath = new File(args[++i]);
                    continue;
                }
                if ((args[i].equals("-ts") || args[i].equals("-testsuite")) && i + 1 < args.length) {
                    EditJTI.checkUnset(testSuitePath, args[i]);
                    testSuitePath = new File(args[++i]);
                    continue;
                }
                if ((args[i].equals("-wd") || args[i].equals("-workdir")) && i + 1 < args.length) {
                    EditJTI.checkUnset(testSuitePath, args[i]);
                    workDirPath = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-help") || args[i].equals("-usage") || args[i].equals("/?")) {
                    helpFlag = true;
                    continue;
                }
                if (args[i].startsWith("-")) {
                    throw new BadArgs((ResourceBundle)i18n, "editJTI.badOption", args[i]);
                }
                if (i <= args.length - 1) {
                    if (inFile == null) {
                        editCmds = new String[args.length - 1 - i];
                        System.arraycopy(args, i, editCmds, 0, editCmds.length);
                        inFile = new File(args[args.length - 1]);
                    } else {
                        editCmds = new String[args.length - i];
                        System.arraycopy(args, i, editCmds, 0, editCmds.length);
                    }
                    i = args.length - 1;
                    continue;
                }
                throw new BadArgs((ResourceBundle)i18n, "editJTI.badOption", args[i]);
            }
            if (args.length == 0 || helpFlag) {
                EditJTI.usage(System.out);
                if (inFile == null) {
                    return true;
                }
            }
            if (classPath != null && testSuitePath != null) {
                throw new BadArgs(i18n, "editJTI.cantHaveClassPathAndTestSuite");
            }
            if (inFile == null) {
                throw new BadArgs(i18n, "editJTI.noInterview");
            }
            this.verbose = verboseFlag;
            this.out = out;
            try {
                if (workDirPath != null) {
                    this.interview = InterviewParameters.open(testSuitePath, workDirPath, inFile);
                    break block49;
                }
                if (testSuitePath != null) {
                    TestSuite ts;
                    try {
                        ts = TestSuite.open(testSuitePath);
                    }
                    catch (FileNotFoundException e) {
                        throw new Fault(i18n, "editJTI.cantFindTestSuite", testSuitePath);
                    }
                    catch (TestSuite.NotTestSuiteFault e) {
                        throw new Fault(i18n, "editJTI.notATestSuite", testSuitePath);
                    }
                    catch (TestSuite.Fault e) {
                        throw new Fault(i18n, "editJTI.cantOpenTestSuite", new Object[]{testSuitePath, e});
                    }
                    this.load(inFile, ts);
                    break block49;
                }
                if (classPath != null) {
                    URLClassLoader loader = new URLClassLoader(new URL[]{classPath.toURL()});
                    this.load(inFile, loader);
                } else {
                    this.load(inFile);
                }
            }
            catch (Interview.Fault e) {
                throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{inFile.getPath(), e.getMessage()});
            }
            catch (FileNotFoundException e) {
                throw new Fault(i18n, "editJTI.cantFindFile", inFile.getPath());
            }
            catch (IOException e) {
                throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{inFile.getPath(), e});
            }
            catch (IllegalStateException e) {
                if (this.verbose) {
                    e.printStackTrace();
                }
                throw new Fault(i18n, "editJTI.badState", e.getMessage());
            }
        }
        if (NUM_BACKUPS > 0) {
            this.interview.setBackupPolicy(BackupPolicy.simpleBackups(NUM_BACKUPS));
        }
        if (editCmds != null) {
            this.edit(editCmds);
        }
        if (showPathFlag) {
            this.showPath();
        }
        try {
            if (logFile != null) {
                if (previewFlag) {
                    String msg = i18n.getString("editJTI.wouldWriteLog", logFile);
                    out.println(msg);
                } else {
                    this.writeLog(logFile);
                }
            }
        }
        catch (IOException e) {
            throw new Fault(i18n, "editJTI.cantWriteLog", new Object[]{logFile.getPath(), e});
        }
        try {
            if (previewFlag) {
                String msg = this.interview.isEdited() ? i18n.getString("editJTI.wouldSaveEdited", outFile != null ? outFile : inFile) : (outFile != null ? i18n.getString("editJTI.wouldSaveNotEdited", outFile) : i18n.getString("editJTI.wouldNotSave"));
                out.println(msg);
            } else if (outFile != null) {
                this.save(outFile);
            } else if (this.interview.isEdited()) {
                this.save(inFile);
            }
        }
        catch (Interview.Fault e) {
            throw new Fault(i18n, "editJTI.cantOpenFile", new Object[]{outFile.getPath(), e});
        }
        catch (IOException e) {
            File f = outFile == null ? this.interview.getFile() : outFile;
            throw new Fault(i18n, "editJTI.cantSaveFile", new Object[]{f.getPath(), e});
        }
        return this.interview.isFinishable();
    }

    public void load(File inFile) throws IOException, Interview.Fault {
        this.interview = InterviewParameters.open(inFile);
        this.interview.setEdited(false);
    }

    public void load(File inFile, TestSuite ts) throws IOException, Interview.Fault, Fault {
        try {
            this.interview = ts.createInterview();
        }
        catch (TestSuite.Fault e) {
            throw new Fault(i18n, "editJTI.cantCreateInterviewForTestSuite", new Object[]{ts.getPath(), e.getMessage()});
        }
        this.interview.load(inFile);
        this.interview.setEdited(false);
    }

    public void load(File inFile, URLClassLoader loader) throws IOException, Interview.Fault, Fault {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFile));
        Properties p = new Properties();
        p.load(in);
        ((InputStream)in).close();
        String interviewClassName = (String)p.get("INTERVIEW");
        try {
            Class<?> interviewClass = loader.loadClass(interviewClassName);
            this.interview = (InterviewParameters)interviewClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new Fault(i18n, "editJTI.invalidInterview", inFile);
        }
        catch (ClassNotFoundException e) {
            throw new Fault(i18n, "editJTI.cantFindClass", new Object[]{interviewClassName, inFile});
        }
        catch (InstantiationException e) {
            throw new Fault(i18n, "editJTI.cantInstantiateClass", new Object[]{interviewClassName, inFile});
        }
        catch (IllegalAccessException e) {
            throw new Fault(i18n, "editJTI.cantAccessClass", new Object[]{interviewClassName, inFile});
        }
        this.interview.load(inFile);
        this.interview.setEdited(false);
    }

    public void save(File file) throws IOException, Interview.Fault {
        this.interview.save(file);
    }

    public void showPath() {
        int i;
        Question[] path = this.interview.getPath();
        int indent = 0;
        for (i = 0; i < path.length; ++i) {
            indent = Math.max(indent, path[i].getTag().length());
        }
        indent = Math.min(indent, MAX_INDENT);
        for (i = 0; i < path.length; ++i) {
            Question q = path[i];
            String tag = q.getTag();
            String value = q.getStringValue();
            this.out.print(tag);
            int l = tag.length();
            if (l > MAX_INDENT && value != null && value.length() > 0) {
                this.out.println();
                l = 0;
            }
            for (int x = l; x < indent; ++x) {
                this.out.print(' ');
            }
            this.out.print(' ');
            this.out.println(value == null ? "" : value);
        }
    }

    public void writeLog(File logFile) throws IOException {
        WizPrint wp = new WizPrint(this.interview);
        wp.setShowResponses(true);
        wp.setShowResponseTypes(false);
        wp.setShowTags(true);
        BufferedWriter out = new BufferedWriter(new FileWriter(logFile));
        wp.write(out);
    }

    public void edit(String[] cmds) throws Fault {
        for (int i = 0; i < cmds.length; ++i) {
            this.edit(cmds[i]);
        }
    }

    public void edit(String cmd) throws Fault {
        if (cmd == null || cmd.length() == 0) {
            return;
        }
        int eqIndex = cmd.indexOf(61);
        if (Character.isJavaIdentifierStart(cmd.charAt(0)) && eqIndex > 0) {
            this.setValue(cmd.substring(0, eqIndex), cmd.substring(eqIndex + 1));
        } else if (cmd.toLowerCase().startsWith("import:")) {
            this.importFile(new File(cmd.substring("import:".length())));
        } else {
            int left = 0;
            char delim = cmd.charAt(left);
            int center = cmd.indexOf(delim, left + 1);
            if (center == -1) {
                throw new Fault(i18n, "editJTI.badCmd", cmd);
            }
            int right = cmd.length() - 1;
            if (cmd.charAt(right) != delim) {
                throw new Fault(i18n, "editJTI.badCmd", cmd);
            }
            String searchText = cmd.substring(left + 1, center);
            String replaceText = cmd.substring(center + 1, right);
            if (searchText.length() == 0) {
                throw new Fault(i18n, "editJTI.badCmd", cmd);
            }
            this.setMatchingValues(searchText, replaceText);
        }
    }

    private void importFile(File file) throws Fault {
        Properties p;
        BufferedInputStream in;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new Fault(i18n, "editJTI.cantFindImport", file);
        }
        catch (IOException e) {
            throw new Fault(i18n, "editJTI.cantOpenImport", new Object[]{file, e});
        }
        try {
            p = new Properties();
            p.load(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new Fault(i18n, "editJTI.cantReadImport", new Object[]{file, e});
        }
        Question[] path = this.interview.getPath();
        for (int i = 0; i < path.length; ++i) {
            Question q = path[i];
            String v = p.getProperty(q.getTag());
            if (v == null) continue;
            this.setValue(q, v);
            path = this.interview.getPath();
        }
    }

    private void setMatchingValues(String searchText, String replaceText) throws Fault {
        boolean found = false;
        Question[] path = this.interview.getPath();
        for (int i = 0; i < path.length; ++i) {
            int pos;
            Question q = path[i];
            String currValue = q.getStringValue();
            if (currValue == null || (pos = EditJTI.match(searchText, currValue, false, false)) < 0) continue;
            String newValue = currValue.substring(0, pos) + replaceText + currValue.substring(pos + searchText.length());
            this.setValue(q, newValue);
            found = true;
            path = this.interview.getPath();
        }
        if (!found) {
            throw new Fault(i18n, "editJTI.cantFindMatch", searchText);
        }
    }

    private void setValue(String tag, String value) throws Fault {
        Question[] path = this.interview.getPath();
        for (int i = 0; i < path.length; ++i) {
            Question q = path[i];
            if (!q.getTag().equals(tag)) continue;
            this.setValue(q, value);
            return;
        }
        throw new Fault(i18n, "editJTI.cantFindQuestion", tag);
    }

    private void setValue(Question q, String value) throws Fault {
        try {
            String oldValue = q.getStringValue();
            q.setValue(value);
            if (this.verbose) {
                this.out.println(i18n.getString("editJTI.update", new Object[]{q.getTag(), oldValue, q.getStringValue()}));
            }
        }
        catch (Interview.Fault e) {
            throw new Fault(i18n, "editJTI.cantSetValue", new Object[]{q.getTag(), e.getMessage()});
        }
    }

    private static int match(String s1, String s2, boolean considerCase, boolean word) {
        int s1len = s1.length();
        int s2len = s2.length();
        for (int i = 0; i <= s2len - s1len; ++i) {
            if (!s1.regionMatches(!considerCase, 0, s2, i, s1len) || word && (!word || i != 0 && !EditJTI.isBoundaryCh(s2.charAt(i - 1)) || i + s1len != s2.length() && !EditJTI.isBoundaryCh(s2.charAt(i + s1len)))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }

    private static void checkUnset(Object item, String option) throws BadArgs {
        if (item != null) {
            throw new BadArgs((ResourceBundle)i18n, "editJTI.dupOption", option);
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }

        Fault(I18NResourceBundle i18n, String s, Object[] o) {
            super(i18n.getString(s, o));
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(ResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        BadArgs(ResourceBundle i18n, String s, Object o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }

        BadArgs(ResourceBundle i18n, String s, Object[] o) {
            super(MessageFormat.format(i18n.getString(s), o));
        }
    }
}

