<%--
   Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
   SUN PROPRIETARY/CONFIDENTIAL.  Use is subject license terms.
--%>

<%@ page import="com.sun.ts.tests.jsp.common.util.JspTestUtil,
             javax.el.ValueExpression,
             javax.el.ELContext"%>
<%@ page contentType="text/plain" %>

<%!
private static final String VARIABLE_EXPR = "${foo}";
private static final String EXPECTED_VALUE = "bar";
private static final int ITERATIONS = 5; 
%>

<% 
    if (pageContext != null) {
        ELContext elContext = pageContext.getELContext();

        if (elContext != null) {
            JspApplicationContext jaContext = 
                    JspFactory.getDefaultFactory().getJspApplicationContext(
                    pageContext.getServletContext());
            if (jaContext != null) {
                
                try {

                    // parse the value expression
                    ValueExpression vexp = 
                            jaContext.getExpressionFactory().createValueExpression(
                            elContext, VARIABLE_EXPR, VARIABLE_EXPR.getClass());

                    if (vexp != null) {
                
                        // set a value for it and do a sanity check
                        out.println("Setting value for value expression");
                        vexp.setValue(elContext, EXPECTED_VALUE);
			for (int i = 1; i <= ITERATIONS; ++i) {
                            String name = (String) vexp.getValue(elContext);
                            if (!name.equals(EXPECTED_VALUE)) {
                                out.println("Test FAILED on iteration " + i);
                                out.println("Set value = " + EXPECTED_VALUE);
                                out.println("Got value = " + name); 
			        return;
                            }
                        }

                        out.println("Test PASSED");

                    } 
                    else 
                        out.println("Test FAILED. Null value returned for expression.");
                 } catch (Throwable t) {
                    JspTestUtil.handleThrowable(t, out, "CreateValueExpressionTest");
                 }
            }
            else
                out.println("Test FAILED. Unable to obtain JspApplicationContext");
        }
        else
            out.println("Test FAILED. Unable to obtain ELContext");
    } 
    else 
        out.println("Test FAILED.  Unable to obtain PageContext.");
%>
