/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jsp.spec.core_syntax.scripting.el;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class EchoTag extends BodyTagSupport {

    private String _echo = null;
    private String _static = null;

    public void setEcho(String echo) {
        _echo = echo;
    }

    public void setStatic(String staticString) {
        _static = staticString;
    }

    public int doAfterBody() throws JspException {
        BodyContent body = this.getBodyContent();
        try {
            body.writeOut(body.getEnclosingWriter());
        } catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", ioe);
        }
        return SKIP_BODY;
    }

    public int doEndTag() throws JspException {
        if (_echo != null) {
            try {
                pageContext.getOut().println("Expression from attribute: " +
                    _echo);
                pageContext.getOut().println("String from attribute: " +
                        _static);
            } catch (IOException ioe) {
                throw new JspException("Unexpected IOException!", ioe);
            } finally {
                _echo = null;
            }
        }
        return EVAL_PAGE;
    }
}
