/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: AttributeTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.spec.core_syntax.actions.attribute;

import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

public class AttributeTag extends TagSupport {
    private static final String NL = System.getProperty("line.separator", "\n");
    
    /**
     * The attribute as evaluated by the container.
     */
    private String _attribute = null;

    /**
     * What the test expects to be the result of the
     * evaluation by the container.
     */
    private String _expected = null;

    /**
     * Sets the attribute as evaluated by the container.
     * @param attribute - the evaluated attribute value
     */
    public void setAttribute(String attribute) {
        _attribute = attribute;
    }

    /**
     * Sets the expected result of the attribute evaluation.
     * @param expected - the result the test expects
     */
    public void setExpected(String expected) {
        _expected = expected;
    }

    /**
     * Prints 'Test PASSED' if the evaluated result is the same as the expected
     * result, otherwise 'Test FAILED' will be printed along with an explanation.
     * @return EVAL_PAGE
     * @throws JspException if an unexpected error occurs
     */
    public int doEndTag() throws JspException {
        JspWriter out = pageContext.getOut();
        try {
            if (_expected.equals(_attribute)) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Expected the attribute value to be:" +
                    " '" + _expected + "'." + NL + "Received: '" + _attribute + "'.");
            }
        } catch (IOException ioe) {
            throw new JspException("Unexpected IOException!", ioe);
        }
        return EVAL_PAGE;
    }
}
