/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 63740 2011-10-13 18:02:10Z dougd $
 */

/*
 * @(#)URLClient.java	1.36 02/11/04
 */

package com.sun.ts.tests.jsp.spec.configuration.xml;


import java.io.PrintWriter;
import com.sun.ts.lib.harness.EETest.Fault;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsp.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {
    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out), 
                   new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the 
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {

        setContextRoot("/jsp_config_xml_web");

        return super.run(args, out, err);
    }

    /*
     *   @class.setup_props:	 webServerHost;
     *				             webServerPort;
     *				             ts_home;
     *
     */

    /* Run test */

    /*
     * @testName: jspConfigurationIsXmlUnspecTest
     * @assertion_ids: PENDING
     * @test_Strategy: Validate that if is-xml is not specified for a
     *                 property group, that the files matched by the
     *                 url-pattern will not be considered JSP documents.
     * 
     */
    public void jspConfigurationIsXmlUnspecTest() throws Fault {
        TEST_PROPS.setProperty(REQUEST,
            "GET /jsp_config_xml_web/unspec/NonXmlTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING, "Test PASSED");
        invoke();
    }

    /*
     * @testName: jspConfigurationIsXmlFalseTest
     * @assertion_ids: JSP:SPEC:150.2
     * @test_Strategy: Validate that if is-xml is set to false for a
     *                 property group, that the files matched by the
     *                 url-pattern will not be considered JSP documents.
     */
    public void jspConfigurationIsXmlFalseTest() throws Fault {
        TEST_PROPS.setProperty(REQUEST,
            "GET /jsp_config_xml_web/xmlfalse/NonXmlTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty(SEARCH_STRING, "Test PASSED");
        invoke();
    }

    /*
     * @testName: jspConfigurationIsXmlTrueTest
     * @assertion_ids: JSP:SPEC:150.1
     * @test_Strategy: Validate that if is-xml is set to true for a
     *                 property group, that the files matched by the
     *                 url-pattern will be considered JSP documents.
     */
    public void jspConfigurationIsXmlTrueTest() throws Fault {
        TEST_PROPS.setProperty(REQUEST,
            "GET /jsp_config_xml_web/xmltrue/XmlJspTest.xsp HTTP/1.1");
        TEST_PROPS.setProperty(UNEXPECTED_RESPONSE_MATCH, "jsp:page|directive");
        TEST_PROPS.setProperty(SEARCH_STRING, "Test PASSED");
        invoke();
    }
}
