/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleExcTag.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.dynamicattributes;

import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class SimpleExcTag extends SimpleTagSupport implements DynamicAttributes {

    /**
     * Default constructor.
     */
    public SimpleExcTag() {
        super();
    }

    /**
     * If called, it will fail the test.
     * @throws JspException not thrown
     * @throws IOException not thrown
     */
    public void doTag()
        throws JspException, IOException {
        this.getJspContext().getOut().println("Test FAILED.  Container incorrectly" +
            " called doTag() after setDynamicAttribute() threw a JspException.");
    }

    /**
     * Throws a JspException.
     * @param uri - the namespace of the attribute (if any)
     * @param localName - the name of the attribute
     * @param value - the value of the attribute
     * @throws JspException if an error occurs
     */
    public void setDynamicAttribute(
        String uri, String localName, Object value)
        throws JspException {
        throw new JspException("JspException");
    }
}
