/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.api.javax_el.arrayelresolver;

import com.sun.ts.tests.common.el.api.resolver.ResolverTest;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.ELContext;
import javax.el.ArrayELResolver;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class ArrayELResolverTag extends SimpleTagSupport {

    public void doTag() throws JspException, IOException {

	StringBuffer buf = new StringBuffer();
	String[] colors = { "red", "blue", "green" };
	JspWriter out = getJspContext().getOut();
	ELContext context = getJspContext().getELContext();
	ArrayELResolver arrayResolver = new ArrayELResolver();

	try {
	    boolean pass = ResolverTest.testELResolver(context, arrayResolver,
		    colors, Integer.valueOf(1), "yellow", buf, false);
	    out.println(buf.toString());
	    if (pass == true)
		out.println("Test PASSED");

	} catch (Throwable t) {
	    out.println("buffer is " + buf.toString());
	    JspTestUtil.handleThrowable(t, out, "ArrayELResolverTag");
	}
    }
}
