/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TSDeployment2.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
 
package com.sun.ts.lib.porting;

import java.io.*;
import com.sun.ts.lib.deliverable.*;

/**
 * This is a factory class for creating instances of TSDeploymentInterface2.
 * The implementation classes used are determined by the values of the 
 * porting package properties in TS_HOME/bin/ts.jte.
 *  
 * @author	Kyle Grucci
 */	
public class TSDeployment2
{
	private static PropertyManagerInterface propMgr = null;
	
	public static TSDeploymentInterface2 getDeploymentInstance(PrintWriter writer, String sClassName) throws Exception
	{
		return createInstance(sClassName, writer);
	}
	
	private static TSDeploymentInterface2 createInstance(String sClassName, PrintWriter writer) throws Exception
	{
		try
		{
			propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
			
			//create and initialize a new instance of the Deployment class
			Class c = Class.forName(propMgr.getProperty(sClassName));
			TSDeploymentInterface2 ctsDep1 = 
								(TSDeploymentInterface2)c.newInstance();
			ctsDep1.init(writer);
			return ctsDep1;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw e;
		}
	}
}
