/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.Harness;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolManager;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

class HelpMenu
extends JMenu {
    private Component parent;
    private Desktop desktop;
    private UIFactory uif;
    private Listener listener;
    private static WeakHashMap docTable = new WeakHashMap();
    private static WeakHashMap helpBrokerTable = new WeakHashMap();
    private static final String HELP = "help";
    private static final String ABOUT_JAVA = "aboutJava";
    private static final String ABOUT_JAVATEST = "aboutJavaTest";

    HelpMenu(Component parent, Desktop desktop, UIFactory uif) {
        this.parent = parent;
        this.desktop = desktop;
        this.uif = uif;
        this.listener = new Listener();
        String[] items = new String[]{HELP, null, ABOUT_JAVATEST, ABOUT_JAVA};
        uif.initMenu(this, "hm", items, this.listener);
        this.addMenuListener(this.listener);
    }

    private void addTestSuiteItems() {
        JMenuItem[] jmi;
        int i;
        int insertPoint;
        Tool[] tools = this.desktop.getTools();
        if (tools == null || tools.length == 0) {
            return;
        }
        TreeSet<TestSuite> loadedTestSuites = new TreeSet<TestSuite>(new Comparator(){

            public int compare(Object o1, Object o2) {
                TestSuite ts1 = (TestSuite)o1;
                TestSuite ts2 = (TestSuite)o2;
                return ts1.getName().compareTo(ts2.getName());
            }
        });
        Tool selTool = this.desktop.getSelectedTool();
        if (selTool != null) {
            TestSuite[] tss = selTool.getLoadedTestSuites();
            if (tss != null) {
                loadedTestSuites.addAll(Arrays.asList(tss));
            }
        } else {
            for (int i2 = 0; i2 < tools.length; ++i2) {
                TestSuite[] tss = tools[i2].getLoadedTestSuites();
                if (tss == null) continue;
                loadedTestSuites.addAll(Arrays.asList(tss));
            }
        }
        for (insertPoint = this.getItemCount() - 1; insertPoint > 0 && this.getItem(insertPoint - 1) != null; --insertPoint) {
        }
        int count = 0;
        for (TestSuite ts : loadedTestSuites) {
            JMenuItem[] menuItems = this.getMenuItems(ts, count);
            if (menuItems == null || menuItems.length <= 0) continue;
            for (int i3 = 0; i3 < menuItems.length; ++i3) {
                JMenuItem mi = menuItems[i3];
                mi.putClientProperty(this.getClass(), this);
                this.insert(mi, insertPoint++);
            }
            JPopupMenu.Separator sep = new JPopupMenu.Separator();
            sep.putClientProperty(this.getClass(), this);
            JPopupMenu p = this.getPopupMenu();
            p.insert(sep, insertPoint++);
            count += menuItems.length + 1;
        }
        ToolManager[] mgrs = this.desktop.getToolManagers();
        for (i = 0; i < mgrs.length; ++i) {
            jmi = mgrs[i].getHelpPrimaryMenus();
            if (jmi == null) continue;
            for (int j = 0; j < jmi.length; ++j) {
                jmi[j].putClientProperty(this.getClass(), this);
                this.insert(jmi[j], insertPoint++);
            }
        }
        for (i = 0; i < mgrs.length; ++i) {
            jmi = mgrs[i].getHelpTestSuiteMenus();
            if (jmi == null) continue;
            for (int j = 0; j < jmi.length; ++j) {
                jmi[j].putClientProperty(this.getClass(), this);
                this.insert(jmi[j], insertPoint++);
            }
        }
        for (i = 0; i < mgrs.length; ++i) {
            jmi = mgrs[i].getHelpAboutMenus();
            if (jmi == null) continue;
            for (int j = 0; j < jmi.length; ++j) {
                jmi[j].putClientProperty(this.getClass(), this);
                this.add(jmi[j]);
            }
        }
    }

    private void removeTestSuiteItems() {
        for (Component c : this.getMenuComponents()) {
            JComponent comp;
            if (!(c instanceof JComponent) || (comp = (JComponent)c).getClientProperty(this.getClass()) != this) continue;
            this.remove(comp);
        }
    }

    private void showAbout(String title, String s, String contKey, String fieldKey) {
        Vector<String> v = new Vector<String>();
        int start = 0;
        int end = 0;
        while ((end = s.indexOf(10, start)) != -1) {
            v.addElement(s.substring(start, end));
            start = end + 1;
        }
        v.addElement(s.substring(start));
        JTextField[] tfs = new JTextField[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            JTextField tf = new JTextField((String)v.elementAt(i));
            tf.setBorder(null);
            tf.setHorizontalAlignment(0);
            tf.setOpaque(false);
            tf.setBackground(UIFactory.Colors.TRANSPARENT.getValue());
            tf.setEditable(false);
            this.uif.setAccessibleInfo(tf, fieldKey);
            tfs[i] = tf;
        }
        JOptionPane pane = new JOptionPane(tfs, 1);
        pane.setIcon(this.desktop.getLogo());
        pane.setOptionType(0);
        this.uif.setAccessibleInfo(pane, contKey);
        JButton okBtn = this.uif.createCloseButton("hm.about.ok", false);
        pane.setOptions(new Object[]{okBtn});
        JDialog d = pane.createDialog(this.parent, title);
        d.getRootPane().setDefaultButton(okBtn);
        d.setVisible(true);
    }

    private void showHelpSet(HelpSet hs) {
        HelpBroker hb = this.getHelpBroker(hs);
        if (hb != null) {
            hb.setDisplayed(true);
            if (hb instanceof DefaultHelpBroker) {
                ((DefaultHelpBroker)hb).getWindowPresentation().getHelpWindow().toFront();
            }
        } else {
            System.err.println("Unable to display help, the help set isn't available.");
        }
    }

    private HelpBroker getHelpBroker(HelpSet hs) {
        HelpBroker hb = (HelpBroker)helpBrokerTable.get(hs);
        if (hb == null) {
            int dpi = this.uif.getDotsPerInch();
            hb = new DefaultHelpBroker(hs);
            hb.setSize(new Dimension(7 * dpi, 9 * dpi));
            helpBrokerTable.put(hs, hb);
        }
        return hb;
    }

    private JMenuItem[] getMenuItems(TestSuite ts, int count) {
        HelpSet[] docs = (HelpSet[])docTable.get(ts);
        if (docs == null) {
            try {
                docs = ts.getAdditionalDocs();
            }
            catch (TestSuite.Fault e) {
                String msg = this.uif.getI18NString("hm.cantLoadDocs", new Object[]{ts.getName(), e.getMessage()});
                System.err.println(msg);
            }
            if (docs == null) {
                docs = new HelpSet[]{};
            }
            docTable.put(ts, docs);
        }
        if (docs.length == 0) {
            return null;
        }
        Vector<JMenuItem> v = new Vector<JMenuItem>();
        for (int i = 0; i < docs.length; ++i) {
            JMenuItem mi;
            final HelpSet doc = docs[i];
            if (count + i < 10) {
                mi = new JMenuItem(count + i + " " + doc.getTitle());
                mi.setMnemonic(48 + count + i);
            } else {
                mi = new JMenuItem("  " + doc.getTitle());
            }
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HelpMenu.this.showHelpSet(doc);
                }
            });
            v.add(mi);
        }
        Object[] items = new JMenuItem[v.size()];
        v.copyInto(items);
        return items;
    }

    private class Listener
    implements MenuListener,
    ActionListener {
        private Listener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            HelpMenu.this.removeTestSuiteItems();
            HelpMenu.this.addTestSuiteItems();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(HelpMenu.ABOUT_JAVATEST)) {
                JMenuItem src = (JMenuItem)e.getSource();
                DateFormat df = DateFormat.getDateInstance(1);
                String date = null;
                Date dt = ProductInfo.getBuildDate();
                date = dt != null ? df.format(dt) : HelpMenu.this.uif.getI18NString("hm.aboutBadDate");
                String aboutJavaTest = HelpMenu.this.uif.getI18NString("hm.aboutJavaTest", new Object[]{ProductInfo.getName(), ProductInfo.getVersion(), ProductInfo.getMilestone(), ProductInfo.getBuildNumber(), Harness.getClassDir().getPath(), ProductInfo.getBuildJavaVersion(), date});
                HelpMenu.this.showAbout(src.getText(), aboutJavaTest, "hm.aboutJavaTest", "hm.aboutJavaTest.text");
            } else if (cmd.equals(HelpMenu.ABOUT_JAVA)) {
                JMenuItem src = (JMenuItem)e.getSource();
                String aboutJava = HelpMenu.this.uif.getI18NString("hm.aboutJava", new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor"), System.getProperty("java.home"), System.getProperty("java.vendor.url")});
                HelpMenu.this.showAbout(src.getText(), aboutJava, "hm.aboutJava", "hm.aboutJava.text");
            } else if (cmd.equals(HelpMenu.HELP)) {
                HelpBroker helpBroker = HelpMenu.this.desktop.getHelpBroker();
                if (helpBroker != null) {
                    helpBroker.setCurrentID("jthelp.csh");
                    helpBroker.setDisplayed(true);
                    if (helpBroker instanceof DefaultHelpBroker) {
                        ((DefaultHelpBroker)helpBroker).getWindowPresentation().getHelpWindow().toFront();
                    }
                } else {
                    System.err.println("Unable to display help, the help system isn't available.");
                }
            }
        }
    }
}

