/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.HelpLink;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import javax.help.HelpBroker;
import javax.help.JHelpContentViewer;
import javax.swing.SwingUtilities;

public class HelpExternalLink
extends HelpLink {
    public HelpExternalLink() {
        super(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!HelpExternalLink.openUrl(HelpExternalLink.this.getTarget())) {
                    JHelpContentViewer cv = (JHelpContentViewer)SwingUtilities.getAncestorOfClass(JHelpContentViewer.class, e.getComponent());
                    HelpBroker hb = (HelpBroker)cv.getClientProperty("helpBrokerForHelpLink");
                    hb.setCurrentID(HelpExternalLink.this.getTarget());
                    hb.setDisplayed(true);
                }
            }
        });
    }

    public static boolean openUrl(String url) {
        String os = System.getProperty("os.name");
        try {
            if (os != null) {
                if (os.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else if (os.startsWith("Mac OS")) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                } else {
                    String[] commands = new String[]{"xdg-open", "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                    String resultCommand = null;
                    for (int i = 0; i < commands.length && resultCommand == null; ++i) {
                        Process process = Runtime.getRuntime().exec(new String[]{"which", commands[i]});
                        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        int time = 0;
                        int exitValue = -1;
                        while (true) {
                            try {
                                exitValue = process.exitValue();
                            }
                            catch (IllegalThreadStateException e) {
                                if (time >= 10000) {
                                    process.destroy();
                                    break;
                                }
                                Thread.sleep(100L);
                                time += 100;
                                continue;
                            }
                            break;
                        }
                        String result = in.readLine();
                        if (!result.startsWith("/") || !result.endsWith(commands[i]) || exitValue != 0) continue;
                        resultCommand = commands[i];
                    }
                    if (resultCommand == null) {
                        return false;
                    }
                    Runtime.getRuntime().exec(new String[]{resultCommand, url});
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

