/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BaseStateHolderTestServlet.java 72120 2013-06-12 12:09:11Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.validator.common;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

/**
 * <p>
 * Base test Servlet for the {@link StateHolder} interface.
 * </p>
 */
public abstract class BaseStateHolderTestServlet extends HttpTCKServlet {

	// ----------------------------------------------- Public Methods
	/**
	 * <p>
	 * Initializes this {@link javax.servlet.Servlet}.
	 * </p>
	 * 
	 * @param config
	 *            this Servlet's configuration
	 * @throws ServletException
	 *             if an error occurs
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	// ----------------------------------------------- Abstract Methods
	/**
	 * <p>
	 * Creates a new {@link UIComponent} instance.
	 * </p>
	 * 
	 * @return a new {@link UIComponent} instance.
	 */
	protected abstract Validator createValidator();

	// ----------------------------------------------- Test Methods
	// StateHolder.isTransient(), StateHolder.setTransient();
	public void stateHolderIsSetTransientTest(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		PrintWriter out = response.getWriter();

		StateHolder holder;
		if (createValidator() instanceof StateHolder) {
			holder = (StateHolder) createValidator();
		} else {
			out.println("The Specific Validator that you are trying to test "
					+ "does not implement the StateHolder interface!");
			return;
		}

		holder.setTransient(false);

		if (holder.isTransient()) {
			out.println(JSFTestUtil.FAIL + " Expected isTransient() to return"
					+ " false after having explicitly setting it as such via"
					+ " setTransient().");
			return;
		}

		holder.setTransient(true);

		if (!holder.isTransient()) {
			out.println(JSFTestUtil.FAIL
					+ " Expected isTransient() to return true"
					+ " after having explicitly setting it as such via"
					+ " setTransient().");
			return;
		}

		out.println(JSFTestUtil.PASS);
	}

	public void stateHolderRestoreStateNPETest(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		PrintWriter pw = response.getWriter();

		StateHolder holder;
		if (createValidator() instanceof StateHolder) {
			holder = (StateHolder) createValidator();
		} else {
			pw.println("The Specific Validator that you are trying to test "
					+ "does not implement the StateHolder interface!");
			return;
		}

		// Test for null FacesContext throws NPE
		JSFTestUtil.checkForNPE(holder, "restoreState", new Class<?>[] {
				FacesContext.class, Object.class },
				new Object[] { null, "abc" }, pw);

	}

	public void stateHolderSaveStateNPETest(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		PrintWriter pw = response.getWriter();

		StateHolder holder;
		if (createValidator() instanceof StateHolder) {
			holder = (StateHolder) createValidator();
		} else {
			pw.println("The Specific Validator that you are trying to test "
					+ "does not implement the StateHolder interface!");
			return;
		}

		// Test for null FacesContext throws NPE
		JSFTestUtil.checkForNPE(holder, "saveState",
				new Class<?>[] { FacesContext.class }, new Object[] { null },
				pw);

	}
}
