/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: CustomOutput.java 62525 2011-04-15 12:14:31Z dougd $
 */
package com.sun.ts.tests.jsf.api.javax_faces.component.uiviewroot;

import javax.faces.component.UIOutput;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;

public class CustomOutput
        extends UIOutput {

    private boolean processEventInvoked;
    private ComponentSystemEvent event;
    private String myValue = "Default_Test_Value";

    public void processEvent(ComponentSystemEvent event)
            throws AbortProcessingException {
        processEventInvoked = true;
        this.event = event;
    }

    public void reset() {
        processEventInvoked = false;
        event = null;
    }

    public boolean isProcessEventInvoked() {
        return processEventInvoked;
    }

    public ComponentSystemEvent getEvent() {
        return event;
    }

    @Override
    public String getValue(){
        return myValue;
    }

    public void setValue(Object s){
        myValue = s.toString();
    }
}