/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 74779 2017-01-13 00:04:16Z mriem $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.html.htmlselectmanylistbox;

import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.html.HtmlSelectManyListbox;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;


public final class TestServlet 
extends com.sun.ts.tests.jsf.api.javax_faces.component.uiselectmany.TestServlet {

    private static final String[] attrNames = {
        "accesskey", "dir", "lang", "onblur", "onchange", "onclick",
        "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup",
        "onmousedown", "onmousemove", "onmouseout", "onmouseover",
        "onmouseup", "size", "style", "styleClass", "tabindex",
        "title", "disabled", "readonly", "disabledClass", "enabledClass"
    };

    /**
     * <p>Initializes this {@link javax.servlet.Servlet}.</p>
     * 
     * @param config this Servlet's configuration
     * @throws ServletException if an error occurs
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        setRendererType("javax.faces.Listbox");
        setAttributeNames(attrNames);
    }


    /**
     * <p>Creates a new {@link UIComponent} instance.</p>
     * 
     * @return a new {@link UIComponent} instance.
     */
    protected UIComponentBase createComponent() {
        return new HtmlSelectManyListbox();
    }
    
// ------------------------------------------- Test Methods ----

}
