/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: CustomOutput.java 75507 2017-09-15 08:22:32Z anajosep $
 */

package com.sun.ts.tests.jsf.api.javax_faces.component.annotation;

import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIOutput;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;

@ListenerFor(systemEventClass = PostAddToViewEvent.class,
sourceClass = CustomOutput.class)
@ResourceDependency(name = "#{'hello.js'}", library = "test",
target = "#{'body'}")
@ResourceDependency(name = "black-n-blue.css", library = "#{'test'}",
target = "body")
@ResourceDependency(name = "black-n-red.css", library = "",
target = "")
public class CustomOutput
        extends UIOutput
        implements ComponentSystemEventListener {

    private boolean processEventInvoked;
    private ComponentSystemEvent event;

    public void processEvent(ComponentSystemEvent event)
            throws AbortProcessingException {
        processEventInvoked = true;
        this.event = event;
    }

    public void reset() {
        processEventInvoked = false;
        event = null;
    }

    public boolean isProcessEventInvoked() {
        return processEventInvoked;
    }

    public ComponentSystemEvent getEvent() {
        return event;
    }
}