 /*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */

package com.sun.ts.tests.jpa.jpa22.repeatable.namednativequery;

 import javax.persistence.*;

@NamedNativeQuery(name = "findAllSQLCoffees2", query = "select * from COFFEE", resultClass = Coffee.class)
@NamedNativeQuery(name = "findAllSQLCoffees", query = "select * from COFFEE", resultSetMapping = "CoffeeResult")
@SqlResultSetMapping(name="CoffeeResult",
	entities=@EntityResult(entityClass=Coffee.class))
	@NamedQuery(name="findAllCoffees",
		 query="Select Distinct c from Coffee c")
	@NamedQuery(name="findAllNewCoffees",
		query="Select NEW com.sun.ts.tests.jpa.jpa22.repeatable.namednativequery.Coffee(c.id, c.brandName, c.price) from Coffee c where c.price <> 0")
@Entity
@Table(name = "COFFEE")
public class Coffee implements java.io.Serializable {
	private static final long serialVersionUID = 22L;
	private Integer id;
    private String brandName;
    private float price;
    
    public Coffee() {
    }
    
    public Coffee(Integer id, String brandName, float price) {
	this.id = id;
	this.brandName = brandName;
        this.price = price;
    }
    
    @Id 
    @Column(name="ID")
    public Integer getId() {
        return id;
    }
    public void setId(Integer id) {
        this.id = id;
    }
    
    @Column(name="BRANDNAME")
    public String getBrandName() {
        return brandName;
    }
    public void setBrandName(String bName) {
        this.brandName = bName;
    }
   
    @Column(name="PRICE")
    public float getPrice() {
        return price;
    }
    public void setPrice(float price) {
        this.price = price;
    }


    public String toString() {
        return "Coffee id=" + getId() + ", brandName=" + getBrandName() + ", price=" + getPrice();
    }
}
