/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.jpa22.repeatable.joincolumn;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import java.io.Serializable;

@Entity
@IdClass(DID2EmployeeId.class)
public class DID2Employee implements Serializable {

    private static final long serialVersionUID = 22L;

    @Id String firstName;
    @Id String lastName;
    int empNo;

    public DID2Employee() {
    }

    public DID2Employee(DID2EmployeeId eId) {
        this(eId.getFirstName(), eId.getLastName());
    }

    public DID2Employee(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public int getEmpNo() {
        return empNo;
    }

    public void setEmpNo(int empNo) {
        this.empNo = empNo;
    }

    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
}
