/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.relationship.bidironexone;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import java.io.Serializable;

/**
 *
 * @author Raja Perumal
 */
@Entity
public class BiDir1X1Person implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private Long id;
    private String name;

    // Bi-directional OnePerson OneProject
    @OneToOne(cascade = CascadeType.ALL)
    private BiDir1X1Project project;

    public BiDir1X1Person() {
    }

    public BiDir1X1Project getProject() {
        return project;
    }

    public void setProject(BiDir1X1Project project) {
        this.project = project;
    }

    public BiDir1X1Person(Long i, String string) {
        this.id =i;
        this.name=string;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "bindironexone.BiDir1X1Person[id=" + id + "]";
    }

}
