package com.sun.ts.tests.jpa.core.override.entitylistener;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.core.override.util.CallBackCounts;

import javax.persistence.PostPersist;
import javax.persistence.PrePersist;


public class ListenerC {

    public ListenerC() {
    }

    @PrePersist
    public void prePersistFromXML(Object obj) {
        updateCallBackCount("prePersist");
        TestUtil.logTrace("in perpersist");
    }

    @PostPersist
    public void postPersistFromXML(Object obj) {
        updateCallBackCount("postPersist");
        TestUtil.logTrace("in postpersist");
    }

    protected void updateCallBackCount(String callBackKeyName) {
        CallBackCounts.updateCount(callBackKeyName);
    }
}
