/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 

/*
 * $Id: FullTimeEmployee.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.inheritance.nonentity;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import java.sql.Date;

/*
 * FullTimeEmployee
 */

@Entity
@DiscriminatorValue("EXEMPT")
public class FullTimeEmployee extends Employee {

    private float salary;


    public FullTimeEmployee() {
    }

    public FullTimeEmployee(int id, String firstName, String lastName, Date hireDate,
                        float salary)
    {
                this.id = id;
                this.firstName = firstName;
                this.lastName = lastName;
                this.hireDate = hireDate;
                this.salary = salary;
    }


   // ===========================================================
   // getters and setters for the state fields

    @Column(name="SALARY")
    public float getSalary() {
        return salary;
    }
    public void setSalary(float salary) {
        this.salary = salary;
    }
    
}
