/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.temporal;


import javax.persistence.*;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Entity
@Table(name = "DATE_TABLE")
@Access(AccessType.FIELD)
public class A2_Field implements java.io.Serializable {

    // ===========================================================
    // instance variables

    @Id
    @Temporal(TemporalType.DATE)
    protected Date id;

    protected String stringVersion=null;


    // ===========================================================
    // constructors
    public A2_Field() {
    }

    public A2_Field(Date id) {
        this.id = id;
    }

    public A2_Field(Date id, String stringVersion) {
        this.id = id;
        this.stringVersion = stringVersion;
    }

    public Date getId() {
        return id;
    }
    
    public void setId(Date id){
        this.id=id;       
    }


    public String getStringVersion() {
        return this.stringVersion;
    }

    public void setStringVersion(String stringVersion) {
            this.stringVersion = stringVersion;
    }

    public boolean equals(Object o) {
        A2_Field other;
        boolean result = false;

        if (!(o instanceof A2_Field)) {
            return result;
        }
        other = (A2_Field) o;

        if (this.getId().equals(other.getId()) &&
                this.getStringVersion().equals(other.getStringVersion())
                ) {
            result = true;
        }

        return result;
    }


    public int hashCode() {
        int myHash;

        myHash = this.getId().hashCode() + this.getStringVersion().hashCode();

        return myHash;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", date: " + getStringVersion());
        result.append("]");
        return result.toString();
    }
 }
