/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */

package com.sun.ts.tests.jpa.core.annotations.id;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "DATATYPES2")
public class PropertySQLDateId implements java.io.Serializable {


    protected java.sql.Date id;

    private java.sql.Date date;

    public PropertySQLDateId() {
    }

    public PropertySQLDateId(java.sql.Date id, java.sql.Date date) {
        this.id = id;
        this.date = date;
    }

    @Id
    @Column(name = "DATATYPES2_ID")
    public java.sql.Date getId() {
        return id;
    }

    public void setId(java.sql.Date id) {
        this.id = id;
    }

    @Column(name = "DATEDATA")
    public java.sql.Date getDate() {
        return date;
    }

    public void setDate(java.sql.Date date) {
        this.date = date;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        if (getDate() != null) {
            result.append(", date: " + getDate());
        } else {
            result.append(", date: null");
        }
        result.append("]");
        return result.toString();
    }
}
