/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.core.StoredProcedureQuery;

import javax.persistence.*;
import java.util.Date;

/*
 * Employee
 */

@NamedStoredProcedureQueries({
        @NamedStoredProcedureQuery(
                name = "getempfirstnamefromout",
                procedureName = "GetEmpFirstNameFromOut",
                hints = {
                        @QueryHint(name = "fooname", value = "barvalue"),
                        @QueryHint(name = "fooname2", value = "barvalue2")
                },
                parameters = {
                        @StoredProcedureParameter(type = Integer.class, mode = ParameterMode.IN),
                        @StoredProcedureParameter(type = String.class, mode = ParameterMode.OUT)
                }
        )
})

@MappedSuperclass()
public abstract class EmployeeMappedSC implements java.io.Serializable {

    private String firstName;

    public EmployeeMappedSC() {
    }

    public EmployeeMappedSC(String firstName) {
        this.firstName = firstName;

    }

    // ===========================================================
    // getters and setters for the state fields


    @Column(name = "FIRSTNAME")
    public String getFirstName() {
        return firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

}

