/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jpa.common.schema30;

import javax.persistence.*;

/*
 * Phone
 */

@Entity
@Table(name = "PHONE_TABLE")
public class Phone implements java.io.Serializable {

    // Instance variables
    private String id;
    private String area;
    private String number;
    private Address address;

    public Phone() {
    }

    public Phone(String v1, String v2, String v3) {
        id = v1;
        area = v2;
        number = v3;
    }

    public Phone(String v1, String v2, String v3, Address v4) {
        id = v1;
        area = v2;
        number = v3;
        address = v4;
    }


    // getters and setters for state fields
    @Id
    @Column(name = "ID")
    public String getId() {
        return id;
    }

    public void setId(String v) {
        id = v;
    }

    @Column(name = "AREA")
    public String getArea() {
        return area;
    }

    public void setArea(String v) {
        area = v;
    }

    @Column(name = "PHONE_NUMBER")
    public String getNumber() {
        return number;
    }

    public void setNumber(String v) {
        number = v;
    }
    // ===========================================================
    // getters and setters for Association fields

    // Manyx1

    @ManyToOne
    @JoinColumn(
            name = "FK_FOR_ADDRESS")
    public Address getAddress() {
        return address;
    }

    public void setAddress(Address a) {
        address = a;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", area: " + getArea());
        result.append(", number: " + getNumber());
        result.append("]");

        return result.toString();
    }
}
