/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2709;

import java.util.Properties;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;

import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest {
    /**
     * The string to be echoed.
     */
    private static final String STRING = "R2709";
    
    /**
     * The client.
     */
    private W2JRLR2709Client client;

    
    static W2JRLR2709TestService service = null;
    
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client client = new Client();
        Status status = client.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = (W2JRLR2709Client)ClientFactory.getClient(W2JRLR2709Client.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testPortTypeReferences
     *
     * @assertion_ids: WSI:SPEC:R2709
     *
     * @test_Strategy: The supplied WSDL, containg a set of port types, referred to by
     * zero, one and two bindings respectively, has been used by the WSDL-to-Java tool to generate
     * an end point.  If the tool works correctly, the end-point has been built and deployed
     * so it should simply be reachable.
     *
     * @throws Fault
     */
    public void testPortTypeReferences() throws Fault {
        String result;
        try {
            result = client.echoString(STRING);
        } catch (Exception e) {
            throw new Fault("Unable to invoke echoString operation (BP-R2709)", e);
        }
        if (!STRING.equals(result)) {
            throw new Fault("echoString operation returns '" + result + "' in stead of '" + STRING + "' (BP-R2709)");
        }
    }
}
