/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.j2w.rpc.literal.R2702;

import java.util.Properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxws.sharedclients.rpclitclient.*;
import com.sun.ts.tests.jaxws.wsi.constants.DescriptionConstants;
import com.sun.ts.tests.jaxws.wsi.constants.SOAPConstants;
import com.sun.ts.tests.jaxws.wsi.utils.DescriptionUtils;

import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest implements DescriptionConstants, SOAPConstants {
    /**
     * The client.
     */
    private SOAPClient client;
    
    
    static J2WRLShared service = null;

    /**
     * Test entry point.
     * 
     * @param args the command-line argument.
     */
    public static void main(String[] args) {
        Client test = new Client();
        Status status = test.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = ClientFactory.getClient(J2WRLSharedClient.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testBindingTransport
     *
     * @assertion_ids: WSI:SPEC:R2702
     *
     * @test_Strategy: Retrieve the WSDL, generated by the Java-to-WSDL tool,
     * and examine the wsdl:binding elements to ensure that their soap:binding element
     * has a transport that equals "http://schemas.xmlsoap.org/soap/http"
     *
     * @throws Fault
     */
    public void testBindingTransport() throws Fault {
        Document document = client.getDocument();
        Element[] bindings = DescriptionUtils.getBindings(document);
        for (int i = 0; i < bindings.length; i++) {
            verifyBinding(bindings[i]);
        }
    }

    protected void verifyBinding(Element element) throws Fault {
        Element[] children;
        children = DescriptionUtils.getChildElements(element, SOAP_NAMESPACE_URI, SOAP_BINDING_LOCAL_NAME);
        if (children.length == 0) {
            throw new Fault("Required soap:binding element not present (BP-R2702)");
        }
        verifySOAPBinding(children[0]);
        
    }

    protected void verifySOAPBinding(Element element) throws Fault {
        String transport = element.getAttribute(SOAP_TRANSPORT_ATTR);
        if (!transport.equals(SOAP_TRANSPORT)) {
            throw new Fault("The SOAP transport '" + transport + "' is invalid (BP-R2702)");
        }
    }
}
