/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: RespectBindingFeatureTestImpl31.java 52501 2007-01-24 02:29:49Z lschwenk $
 */
package com.sun.ts.tests.jaxws.wsa.w2j.document.literal.respectbindingfeature;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.RespectBinding;

@WebService(
    portName="RespectBindingFeatureTest31Port",
    serviceName="RespectBindingFeatureTestService",
    targetNamespace="http://respectbindingfeatureservice.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/RespectBindingFeatureTestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.wsa.w2j.document.literal.respectbindingfeature.RespectBindingFeatureTest31"
)
@BindingType(value=SOAPBinding.SOAP11HTTP_BINDING)
@Addressing(enabled=false)
@RespectBinding(enabled=false)

public class RespectBindingFeatureTestImpl31 implements RespectBindingFeatureTest31 {

    public int addNumbers(Holder<String> testname, int number1, int number2) {
        if (number1 < 0 || number2 < 0) {
            throw new RespectBindingFeatureException("One of the numbers received was negative:"+number1+", "+number2);
        }
        System.out.printf("Adding %s and %s\n", number1, number2);
	return number1 + number2;
    }

}
