/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: AddressingEndpointImpl.java 52501 2007-01-24 02:29:49Z lschwenk $
 */

package com.sun.ts.tests.jaxws.mapping.j2wmapping.document.literal.bare;

import javax.xml.ws.WebServiceException;

import javax.jws.WebService;
import javax.xml.ws.BindingType;
import javax.xml.ws.soap.SOAPBinding;
import javax.xml.ws.soap.Addressing;

@WebService(
    name="AddressingEndpoint",
    serviceName="AddressingService",
    targetNamespace="http://doclitservice.org/wsdl"
)
@javax.jws.soap.SOAPBinding(
    style=javax.jws.soap.SOAPBinding.Style.DOCUMENT,
    use=javax.jws.soap.SOAPBinding.Use.LITERAL,
    parameterStyle=javax.jws.soap.SOAPBinding.ParameterStyle.BARE
)
@BindingType(value=SOAPBinding.SOAP11HTTP_BINDING)
@Addressing
public class AddressingEndpointImpl {

    @javax.xml.ws.Action(input="input1")
    public void address1(String s) 
    {
    }
    @javax.xml.ws.Action(output="output2")
    public String address2() 
    {
        return "hello";
    }

    @javax.xml.ws.Action(fault={
          @javax.xml.ws.FaultAction(className=MyFault1.class, value="fault1")
    })
    public String address3(String s) throws MyFault1
    {
       throw new MyFault1("MyFault1");
    }

    @javax.xml.ws.Action(output = "output4", fault={
          @javax.xml.ws.FaultAction(className=MyFault1.class, value="fault1")
    })
    public String address4() throws MyFault1
    {
           throw new MyFault1("MyFault1");
    }

    @javax.xml.ws.Action(input = "input5",output = "output5", fault={
          @javax.xml.ws.FaultAction(className=MyFault1.class, value="fault1")
    })
    public String address5(String s) throws MyFault1
    {
           throw new MyFault1("MyFault1");
    }

    @javax.xml.ws.Action(input = "")
    public void address6(String s) throws MyFault1
    {
    }

    @javax.xml.ws.Action(output = "")
    public String address7() throws MyFault1
    {
       return "hello";
    }
}
