/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSBuildListener;
import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;

public class TaskUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String SCCS_CMD = "/usr/ccs/bin/sccs";
    public static final String DEFAULT_DIST = "dist";

    public static void deleteDir(File dir, Project project, boolean quiet) {
        Delete del = new Delete();
        del.setProject(project);
        del.init();
        del.setQuiet(quiet);
        del.setIncludeEmptyDirs(true);
        del.setFailOnError(false);
        del.setDir(dir);
        del.perform();
    }

    public static boolean isCompatDir(File dir) {
        if (dir == null) {
            return false;
        }
        return TaskUtil.isCompatDir(dir.getPath());
    }

    public static boolean isCompatDir(String path) {
        if (path == null) {
            return false;
        }
        return path.indexOf("/compat") != -1 || path.indexOf("\\compat") != -1;
    }

    public static File getFullDistDir(File srcDir, Project proj) {
        File destDir = null;
        String sDistDir = proj.getProperty("dist.dir");
        if (sDistDir == null) {
            sDistDir = System.getProperty("dist.dir");
        }
        destDir = sDistDir != null && sDistDir.length() != 0 ? new File(sDistDir, TaskUtil.path2PkgDir(srcDir)) : new File(new File(TSBuildListener.tsHome, DEFAULT_DIST), TaskUtil.path2PkgDir(srcDir));
        return destDir;
    }

    public static File getFullDistDir(Project proj) {
        File destDir = null;
        String sDistDir = proj.getProperty("dist.dir");
        destDir = sDistDir != null && sDistDir.length() != 0 ? new File(sDistDir, TaskUtil.project2PkgDir(proj)) : new File(new File(TSBuildListener.tsHome, DEFAULT_DIST), TaskUtil.path2PkgDir(TaskUtil.getCurrentSrcDir(proj)));
        return destDir;
    }

    public static String path2PkgDir(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        String pkgDir = null;
        String toFind = "/src/";
        if (!(path = path.replace('\\', '/')).endsWith("/")) {
            path = path + "/";
        }
        boolean found = false;
        int i = path.indexOf(toFind);
        while (i != -1) {
            String before = path.substring(0, i);
            if (new File(before, "bin").exists() || new File(before, "lib").exists()) {
                pkgDir = path.substring(i + 5);
                break;
            }
            i = path.indexOf(toFind, i + 5);
        }
        if (pkgDir != null && pkgDir.endsWith("/")) {
            pkgDir = pkgDir.substring(0, pkgDir.length() - 1);
        }
        return pkgDir;
    }

    public static String project2PkgDir(Project proj) {
        return TaskUtil.path2PkgDir(TaskUtil.getCurrentSrcDir(proj));
    }

    public static String path2PkgDir(File path) {
        return TaskUtil.path2PkgDir(path.getPath());
    }

    public static File getCurrentSrcDir(Project project) {
        File srcDir = null;
        String pkgDir = project.getProperty("pkg.dir");
        if (pkgDir != null && pkgDir.length() != 0) {
            srcDir = new File(TSBuildListener.tsHome, "src/" + pkgDir);
            return srcDir;
        }
        srcDir = project.getBaseDir();
        if (srcDir.compareTo(TSBuildListener.fBin) == 0) {
            srcDir = new File(System.getProperty("user.dir"));
        }
        return srcDir;
    }

    public static String replace(String whole, String old, String sub) {
        if (whole == null || old == null || sub == null) {
            return whole;
        }
        int start = 0;
        int pos = -1;
        int oldLength = old.length();
        StringBuffer sb = new StringBuffer();
        try {
            pos = whole.indexOf(old, start);
            while (pos >= 0) {
                sb.append(whole.substring(start, pos));
                sb.append(sub);
                start = pos + oldLength;
                pos = whole.indexOf(old, start);
            }
            sb.append(whole.substring(start));
        }
        catch (NullPointerException ex) {
        }
        catch (StringIndexOutOfBoundsException se) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void sccsEdit(Project project, File file) {
        if (!new File(file.getParentFile(), "SCCS/s." + file.getName()).exists()) {
            System.out.println("Not in SCCS, skip sccs edit:" + file.getPath());
            return;
        }
        if (new File(file.getParentFile(), "SCCS/p." + file.getName()).exists()) {
            System.out.println("Already checked out, skip sccs edit:" + file.getPath());
            return;
        }
        TaskUtil.doSccs(project, file, "edit");
    }

    public static void sccsCreate(Project project, File file) {
        TaskUtil.doSccs(project, file, "create");
    }

    public static void sccsCreate(Project project, File dir, String files) {
        TaskUtil.doSccs(project, dir, files, "create");
    }

    public static void sccsDelget(Project project, File file) {
        TaskUtil.sccsDelget(project, file, "This delta is generated by ant task");
    }

    public static void sccsDelget(Project project, File file, String comment) {
        if (!new File(file.getParentFile(), "SCCS/s." + file.getName()).exists()) {
            return;
        }
        TaskUtil.doSccs(project, file, "delget -y'" + comment + "'");
    }

    private static void doSccs(Project project, File dir, String files, String sccsSubCmd) {
        if (dir == null || files == null || files.length() == 0) {
            return;
        }
        ExecTask exec = new ExecTask();
        exec.setProject(project);
        exec.init();
        exec.setExecutable(SCCS_CMD);
        exec.setDir(dir);
        exec.setFailonerror(false);
        exec.setTaskName("SCCS");
        Commandline.Argument arg = exec.createArg();
        arg.setLine(sccsSubCmd + " " + files);
        exec.perform();
    }

    private static void doSccs(Project project, File file, String sccsSubCmd) {
        if (file == null) {
            return;
        }
        ExecTask exec = new ExecTask();
        exec.setProject(project);
        exec.init();
        exec.setExecutable(SCCS_CMD);
        exec.setDir(file.getParentFile());
        exec.setFailonerror(false);
        exec.setTaskName("SCCS");
        Commandline.Argument arg = exec.createArg();
        arg.setLine(sccsSubCmd + " " + file.getName());
        exec.perform();
    }
}

