 /*
  * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
  * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
  */
/*
 * $Id: EntityTransactionWrapper.java 62592 2011-04-20 20:07:16Z kgrucci $
 */

package com.sun.ts.tests.common.vehicle.ejb3share;

import javax.persistence.EntityTransaction;

final public class EntityTransactionWrapper implements EntityTransaction {
    private EntityTransaction delegate;
    
    public EntityTransactionWrapper() {}
    
    public EntityTransactionWrapper(EntityTransaction delegate) {
        this.delegate = delegate;
    }
    
    public void setDelegate(EntityTransaction delegate) {
        this.delegate = delegate;
    }
    
    public void rollback() {
        delegate.rollback();
    }

    public boolean isActive() {
        return delegate.isActive();
    }

    public void commit() {
        delegate.commit();
    }

    public void begin() {
        delegate.begin();
    }

    public void setRollbackOnly() {
        delegate.setRollbackOnly();
    }

    public boolean getRollbackOnly() {
        return delegate.getRollbackOnly();
    }
}
