/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFEnvironment;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFTest;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;

class COFTestSuite
extends COFItem {
    private static final String[] cofStatus = new String[4];
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(COFTestSuite.class);
    private COFData cofData;
    private boolean legacyMode = false;
    private String name;
    protected Pattern testCasePattern = Pattern.compile("^(\\S+): (Passed\\.|Failed\\.|Error\\.|Not\\ run\\.)(.*)");
    private TestResultTable trt;

    COFTestSuite(File dir) {
        this.trt = new TestResultTable();
        this.scan(dir);
        this.legacyMode = true;
    }

    COFTestSuite(File dir, COFData cd) {
        this.cofData = cd;
        this.trt = new TestResultTable();
        this.name = this.cofData.get("testsuites.testsuite.name");
        this.scan(dir);
        this.legacyMode = true;
    }

    COFTestSuite(TestResultTable trt) {
        this.trt = trt;
    }

    COFTestSuite(WorkDirectory wd) {
        this(wd, null);
    }

    COFTestSuite(WorkDirectory wd, COFData cd) {
        this.cofData = cd;
        TestSuite ts = wd.getTestSuite();
        this.name = ts.getID();
        this.trt = wd.getTestResultTable();
    }

    COFTestSuite() {
    }

    void scan(File dir) {
        String[] entries = dir.list();
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                File f = new File(dir, entries[i]);
                if (f.isDirectory()) {
                    this.scan(f);
                    continue;
                }
                if (!TestResult.isResultFile(f)) continue;
                try {
                    TestResult tr = new TestResult(f);
                    this.trt.update(tr);
                    continue;
                }
                catch (TestResult.Fault e) {
                    System.err.println(i18n.getString("ts.badTest", new Object[]{f, e.getMessage()}));
                }
            }
        }
    }

    @Override
    void write(XMLWriter out) throws IOException {
        out.startTag("testsuite");
        out.writeAttr("id", "unknownTestSuite:0");
        out.startTag("name");
        out.write(this.name == null ? "unknown" : this.name);
        out.endTag("name");
        out.startTag("tests");
        if (!this.legacyMode) {
            this.trt.waitUntilReady();
        }
        TestResultTable.TreeIterator iter = this.trt.getIterator();
        while (iter.hasNext()) {
            TestResult tr = (TestResult)iter.next();
            out.newLine();
            new COFTest(tr, this.cofData).write(out);
        }
        out.endTag("tests");
        out.endTag("testsuite");
    }

    public COFEnvironment[] getCOFEnvironments(COFData data) {
        COFEnvironment[] evs;
        if (!this.legacyMode) {
            this.trt.waitUntilReady();
        }
        HashMap<String, COFEnvironment> map = new HashMap<String, COFEnvironment>();
        String id = this.cofData.get("environment.id", "env:0").split(":")[0] + ":";
        int id_n = 0;
        TestResultTable.TreeIterator iter = this.trt.getIterator();
        while (iter.hasNext()) {
            TestResult tr = (TestResult)iter.next();
            try {
                String os = tr.getProperty("javatestOS");
                if (map.containsKey(os) || os == null) continue;
                try {
                    String[] split = os.split("[()]");
                    String arch = split[split.length - 1];
                    split = split[0].split(" ", 2);
                    String name = split[0];
                    String version = split[1].trim();
                    data.put("environment.os.arch", arch);
                    data.put("environment.os.name", name);
                    data.put("environment.os.version", version);
                    COFEnvironment e = new COFEnvironment(data, id + id_n++);
                    map.put(os, e);
                }
                catch (Throwable t) {
                }
            }
            catch (TestResult.Fault ex) {}
        }
        Collection values = map.values();
        if (values.isEmpty()) {
            evs = new COFEnvironment[]{new COFEnvironment(data, "env:0")};
        } else {
            evs = new COFEnvironment[values.size()];
            Iterator e = values.iterator();
            int i = 0;
            while (e.hasNext()) {
                evs[i++] = (COFEnvironment)e.next();
            }
        }
        return evs;
    }

    static {
        COFTestSuite.cofStatus[0] = "pass";
        COFTestSuite.cofStatus[1] = "fail";
        COFTestSuite.cofStatus[2] = "error";
        COFTestSuite.cofStatus[3] = "did_not_run";
    }
}

