/*
 * Copyright (c) 2007, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: HttpHeadersTest.java 69819 2013-02-05 12:21:32Z supol $
 */
package com.sun.ts.tests.jaxrs.ee.rs.core.headers;

import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;

@Path(value = "/HeadersTest")
public class HttpHeadersTest {

	@Context
	HttpHeaders hs;
	StringBuffer sb;

	@GET
	@Path("/headers")
	public String headersGet() {
		sb = new StringBuffer();
		List<String> myHeaders = Arrays.asList("Accept", "Content-Type");

		try {
			MultivaluedMap<String, String> rqhdrs = hs.getRequestHeaders();
			Set<String> keys = rqhdrs.keySet();
			sb.append("getRequestHeaders= ");
			for (String header : myHeaders) {
				if (keys.contains(header)) {
					sb.append("Found " + header + ": "
							+ hs.getRequestHeader(header) + "; ");
				}
			}
		} catch (Throwable ex) {
			sb.append("Unexpected exception thrown in getRequestHeaders: "
					+ ex.getMessage());
			ex.printStackTrace();
		}
		return sb.toString();
	}

	@GET
	@Path("/acl")
	public String aclGet() {
		sb = new StringBuffer();
		try {
			sb.append("Accept-Language");

			List<Locale> acl = hs.getAcceptableLanguages();
			sb.append("getLanguage= ");
			for (Locale tmp : acl) {
				sb.append(langToString(tmp)).append("; ");
			}
		} catch (Throwable ex) {
			sb.append("Unexpected exception thrown in getAcceptableLanguages: "
					+ ex.getMessage());
			ex.printStackTrace();
		}
		return sb.toString();
	}

	@GET
	@Path("/amt")
	public String amtGet() {
		sb = new StringBuffer();
		try {
			sb.append("getAcceptableMediaTypes");
			List<MediaType> acmts = hs.getAcceptableMediaTypes();

			for (MediaType mt : acmts) {
				sb.append(mt.getType());
				sb.append("/");
				sb.append(mt.getSubtype());
			}
		} catch (Throwable ex) {
			sb.append("Unexpected exception thrown: " + ex.getMessage());
			ex.printStackTrace();
		}
		return sb.toString();
	}

	@GET
	@Path("/mt")
	public String mtGet() {
		sb = new StringBuffer();

		try {
			sb.append("getMediaType");
			MediaType mt = hs.getMediaType();
			if (mt != null) {
				sb.append(mt.getType());
				sb.append("/");
				sb.append(mt.getSubtype());
				sb.append(" ");

				java.util.Map<java.lang.String, java.lang.String> pmap = mt
						.getParameters();

				sb.append("MediaType size=" + pmap.size());

				Iterator<Entry<String, String>> k = pmap.entrySet().iterator();
				while (k.hasNext()) {
					Entry<String, String> next = k.next();
					String key = next.getKey();
					sb.append("Key " + key + "; Value " + next.getValue());
				}

				sb.append(mt.toString());

				sb.append("MediaType= " + mt.toString() + "; ");
			} else {
				sb.append("MediaType= null; ");
			}
		} catch (Throwable ex) {
			sb.append("Unexpected exception thrown: " + ex.getMessage());
			ex.printStackTrace();
		}
		return sb.toString();
	}

	@GET
	@Path("/cookie")
	public String cookieGet() {
		sb = new StringBuffer();

		try {
			sb.append("getCookies= ");
			Map<String, Cookie> cookies = hs.getCookies();
			sb.append("Cookie Size=" + cookies.size());

			for (Entry<String, Cookie> entry : cookies.entrySet()) {
				sb.append("key=" + entry.getKey() + "; value="
						+ entry.getValue());
				Cookie c = entry.getValue();
				sb.append("Cookie Name=" + c.getName());
				sb.append("Cookie Value=" + c.getValue());
				sb.append("Cookie Path=" + c.getPath());
				sb.append("Cookie Domain=" + c.getDomain());
				sb.append("Cookie Version=" + c.getVersion());

			}
		} catch (Throwable ex) {
			sb.append("Unexpected exception thrown: " + ex.getMessage());
			ex.printStackTrace();
		}
		return sb.toString();
	}

	@PUT
	public String headersPlainPut(String nil) {
		sb = new StringBuffer();
		sb.append("Content-Language");
		sb.append(langToString(hs.getLanguage()));
		return sb.toString();
	}

	@POST
	@Path("date")
	public String date(@Context HttpHeaders headers, String nil) {
		Date date = headers.getDate();
		long time = date.getTime();
		return String.valueOf(time);
	}

	@POST
	@Path("headerstring")
	public String headerString(@Context HttpHeaders headers, String headerName) {
		String header = headers.getHeaderString(headerName);
		return header;
	}

	@GET
	@Path("length")
	public String headerLength(@Context HttpHeaders headers) {
		return String.valueOf(headers.getLength());
	}

	private static String langToString(Locale locale) {
		return locale.toString().replace("_", "-");
	}
}
