/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: Registrar.java 70021 2013-02-14 09:30:04Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.core.configurable;

import javax.ws.rs.core.Configurable;

/**
 * We need the possibility to override the way the registerable is registered
 * The default behavior is for single argument register method
 */
public class Registrar {
	public void register(Configurable<?> config, Object registerable) {
		if (registerable instanceof Class) // register(Class)
			config.register((Class<?>) registerable);
		else if (registerable instanceof String) // setProperty()
			config.property((String) registerable, registerable);
		else
			// register(Object)
			config.register(registerable);
	}
}