/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR1012ClientTwo.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1012;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxrpc.wsi.constants.CTSConstants;

public class W2JRLR1012ClientTwo extends SOAPClient {
    public W2JRLR1012ClientTwo(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://w2jrlr1012testservice.org/W2JRLR1012TestService.wsdl");
        stubContext.setService("W2JRLR1012TestService");
        stubContext.setPortPrefix("W2JRLR1012TestTwo");
        stubContext.setServiceInterface(W2JRLR1012TestTwo.class);
    }

    protected String getEndpointURLProperty() {
        return CTSConstants.w2jrlr1012EndpointTwoProperty;
    }

    protected String getWSDLURLProperty() {
        return CTSConstants.w2jrlr1012WSDLTwoProperty;
    }

    public String echoString(String str) throws Exception {
        NonNullString nns = new NonNullString(str);
        nns = ((W2JRLR1012TestTwo)stubContext.getStub()).echoString(nns);
        return nns.getP1();
    }
}
