/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: FaultTestClient.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.sharedclients.faultclient;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxrpc.wsi.constants.CTSConstants;
import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;

public class FaultTestClient extends SOAPClient {

    public FaultTestClient(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://faulttestservice.org/wsdl");
        stubContext.setService("FaultTest");
        stubContext.setPortPrefix("SoapFaultTest");
        stubContext.setServiceInterface(SoapFaultTest.class);
    }

    public String getEndpointURLProperty() {
        return CTSConstants.faultEndpointProperty;
    }

    public String getWSDLURLProperty() {
        return CTSConstants.faultWSDLProperty;
    }

    public String alwaysThrowsSOAPFaultExceptionDetailNoChildren() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailNoChildren();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailQualifiedChildren() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailQualifiedChildren();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailUnqualifiedChildren() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailUnqualifiedChildren();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailNoAttributes() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailNoAttributes();
    }

    public String alwaysThrowsSOAPFaultExceptionDetailQualifiedAttributes() throws Exception{
        return ((SoapFaultTest)stubContext.getStub()).alwaysThrowsSOAPFaultExceptionDetailQualifiedAttributes();
    }
}
