/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: DescriptionClient.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/*
 * @(#)DescriptionClient.java	1.2 03/05/16
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.sharedclients;

import java.io.IOException;
import java.net.URL;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.sun.ts.lib.harness.EETest;

public class DescriptionClient {

    private String url;

    public String getURL() {
        return url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public Document getDocument() throws EETest.Fault {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new URL(url).openStream());
            return builder.parse(is);
        } catch (FactoryConfigurationError e) {
            throw new EETest.Fault("XML document builder factory configuration problem", e);
        } catch (ParserConfigurationException e) {
            throw new EETest.Fault("XML parser configuration problem", e);
        } catch (IOException e) {
            throw new EETest.Fault("Unable to read description from '" + url + "'", e);
        } catch (SAXException e) {
            throw new EETest.Fault("Unable to parse description from '" + url + "'", e);
        }
    }
}
