/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.NamespaceConstants;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;

import javax.xml.rpc.NamespaceConstants;

import com.sun.javatest.Status;

public class Client extends ServiceEETest
{
    private Properties props = null;

    public static void main(String[] args)
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
     * @class.testArgs:     -ap jaxrpc-url-props.dat
   *   @class.setup_props:
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  NamespaceConstantsTest
     *
     *   @assertion_ids: JAXRPC:JAVADOC:221; JAXRPC:JAVADOC:222; JAXRPC:JAVADOC:223;
     *               JAXRPC:JAVADOC:224; JAXRPC:JAVADOC:225; JAXRPC:JAVADOC:226;
     *               JAXRPC:JAVADOC:227; JAXRPC:JAVADOC:228; JAXRPC:JAVADOC:229;
     *               WS4EE:SPEC:70
     *
     *   @test_Strategy: Verify access to all public NamespaceConstants.
     */
    public void NamespaceConstantsTest() throws Fault {
	TestUtil.logTrace("NamespaceConstantsTest");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Verify access to all public NamespaceConstants");
	    TestUtil.logMsg("NamespaceConstants.NSPREFIX_SCHEMA_XSD="+
				NamespaceConstants.NSPREFIX_SCHEMA_XSD);
	    TestUtil.logMsg("NamespaceConstants.NSPREFIX_SCHEMA_XSI="
				+NamespaceConstants.NSPREFIX_SCHEMA_XSI);
	    TestUtil.logMsg("NamespaceConstants.NSPREFIX_SOAP_ENCODING="
				+NamespaceConstants.NSPREFIX_SOAP_ENCODING);
	    TestUtil.logMsg("NamespaceConstants.NSPREFIX_SOAP_ENVELOPE="
				+NamespaceConstants.NSPREFIX_SOAP_ENVELOPE);
	    TestUtil.logMsg("NamespaceConstants.NSURI_SCHEMA_XSD="
				+NamespaceConstants.NSURI_SCHEMA_XSD);
	    TestUtil.logMsg("NamespaceConstants.NSURI_SCHEMA_XSI="
				+NamespaceConstants.NSURI_SCHEMA_XSI);
	    TestUtil.logMsg("NamespaceConstants.NSURI_SOAP_ENCODING="
				+NamespaceConstants.NSURI_SOAP_ENCODING);
	    TestUtil.logMsg("NamespaceConstants.NSURI_SOAP_ENVELOPE="
				+NamespaceConstants.NSURI_SOAP_ENVELOPE);
	    TestUtil.logMsg("NamespaceConstants.NSURI_SOAP_NEXT_ACTOR="
				+NamespaceConstants.NSURI_SOAP_NEXT_ACTOR);
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("NamespaceConstantsTest failed", e);
        }

	if (!pass)
	    throw new Fault("NamespaceConstantsTest failed");
    }
}
