/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.Fatal;
import javasoft.sqe.apiCheck.JReader;
import javasoft.sqe.apiCheck.NormUnits;
import javasoft.sqe.apiCheck.Tran;
import javasoft.sqe.apiCheck.Unit;
import javasoft.sqe.apiCheck.UnitClass;
import javasoft.sqe.apiCheck.UnitPack;
import javasoft.sqe.apiCheck.Units;

class ReadJhu
extends JReader {
    Units units;
    Tran tran;
    int errs;
    String defpack = null;
    String defclass = null;
    static final int syn_UPDATE = 1000;
    static final int syn_PACKAGE = 1001;
    static final int syn_CLASS = 1002;
    static final int syn_ADD = 1003;
    static final int syn_DELETE = 1004;
    static final int syn_CHANGE = 1005;
    static final int syn_TO = 1006;
    static final int syn_END = 1007;
    static final int syn_INTERFACE = 1008;

    ReadJhu(Tran t) {
        this.tran = t;
    }

    boolean Read(API api, String f) {
        File file = new File(f);
        if (file.isDirectory()) {
            String[] flist = file.list();
            file = null;
            if (flist != null) {
                int i = 0;
                while (i < flist.length) {
                    if (!this.Read(api, f + File.separatorChar + flist[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        file = null;
        boolean r = false;
        if (this.Open(f)) {
            this.units = api.GetUnits();
            NormUnits norm = new NormUnits();
            norm.Do(this.units);
            norm = null;
            r = this.Read();
            if (!r) {
                System.err.println("error in \"" + f + "\"");
            }
            this.defpack = null;
            this.defclass = null;
            this.tran.defupd = null;
            this.tran.defstat = null;
            this.units = null;
            this.Close();
        }
        return r;
    }

    boolean Open(String f) {
        if (super.Open(f)) {
            this.st.wordChars(35, 35);
            return true;
        }
        return false;
    }

    boolean Read() {
        try {
            this.errors = 0;
            this.ReadWord();
            while (this.syn != -1) {
                this.st.eolIsSignificant(true);
                this.errs = 0;
                switch (this.syn) {
                    case 0: {
                        this.ReadWord();
                        break;
                    }
                    case 1000: {
                        this.ReadWord();
                        this.CheckIdent();
                        this.tran.NewUpdate(this.lex, this.fname);
                        this.ReadWord();
                        this.ReadEol();
                        this.defpack = null;
                        this.defclass = null;
                        break;
                    }
                    case 1001: {
                        this.ReadWord();
                        if (this.syn != 0) {
                            this.CheckIdent();
                            this.defpack = this.lex;
                            this.ReadWord();
                        } else {
                            this.defpack = null;
                        }
                        this.ReadEol();
                        this.defclass = null;
                        break;
                    }
                    case 1002: 
                    case 1008: {
                        this.ReadWord();
                        if (this.syn != 0) {
                            this.CheckIdent();
                            this.defclass = this.lex;
                            this.ReadWord();
                        } else {
                            this.defclass = null;
                        }
                        this.ReadEol();
                        break;
                    }
                    case 1003: {
                        this.NewStatement("#ADD");
                        this.ReadWord();
                        this.ReadEol();
                        this.DoAdd();
                        this.ErrCheck();
                        break;
                    }
                    case 1004: {
                        this.NewStatement("#DELETE");
                        this.ReadWord();
                        this.ReadEol();
                        this.DoDelete();
                        this.ErrCheck();
                        break;
                    }
                    case 1005: {
                        this.NewStatement("#CHANGE");
                        this.ReadWord();
                        this.ReadEol();
                        this.DoChange();
                        this.ErrCheck();
                        break;
                    }
                    case 1007: {
                        this.ReadWord();
                        break;
                    }
                    default: {
                        this.Err("Invalid symbol");
                        this.ReadWord();
                    }
                }
            }
            return this.errors == 0;
        }
        catch (Error x) {
            return false;
        }
    }

    void NewStatement(String s) {
        if (this.tran.defupd == null) {
            this.tran.NewUpdate("", this.fname);
        }
        this.tran.NewStatement(s, this.st.lineno());
    }

    void DoAdd() throws Fatal {
        Units uu = new Units();
        while (this.ReadUnitNew(uu)) {
            int i = 0;
            while (i < uu.size()) {
                Unit u = (Unit)uu.get(i);
                if (u instanceof UnitPack) {
                    this.Err("package not allowed in #ADD", u);
                } else {
                    this.units.add(u);
                    this.tran.Transform(null, u);
                }
                ++i;
            }
            uu.removeAllElements();
        }
    }

    void DoDelete() throws Fatal {
        Units uu = new Units();
        while (this.ReadUnitOld(uu)) {
            int i = 0;
            while (i < uu.size()) {
                Unit u = (Unit)uu.get(i);
                if (!this.tran.Transform(u, null)) {
                    this.Err("already deleted", u);
                } else if (u instanceof UnitPack || u instanceof UnitClass) {
                    String parent = u.topname + u.name + ".";
                    Enumeration e = this.units.elements();
                    while (e.hasMoreElements()) {
                        Unit x = (Unit)e.nextElement();
                        if (x.topname == null || !x.topname.startsWith(parent)) continue;
                        this.tran.Transform(x, null);
                    }
                }
                ++i;
            }
            uu.removeAllElements();
        }
    }

    void DoChange() throws Fatal {
        Units oldunits = new Units();
        if (!this.ReadUnitOld(oldunits) || oldunits.size() == 0) {
            this.Err("error in change-from item", (String)null);
            ++this.errs;
        } else if (oldunits.size() != 1) {
            this.Err("only single item can be changed", (String)null);
            ++this.errs;
        }
        this.st.eolIsSignificant(true);
        if (this.syn != 1006) {
            this.Err("#TO expected");
            ++this.errs;
        }
        this.ReadWord();
        this.ReadEol();
        Units newunits = new Units();
        if (!this.ReadUnitNew(newunits) || newunits.size() == 0) {
            this.Err("error in change-to item", (String)null);
            ++this.errs;
        } else if (newunits.size() != 1) {
            this.Err("only single item can be changed", (String)null);
            ++this.errs;
        }
        this.st.eolIsSignificant(true);
        if (this.syn != 1007) {
            this.Err("#END expected");
            ++this.errs;
        }
        this.ReadWord();
        this.ReadEol();
        if (this.errs != 0) {
            return;
        }
        Unit oldunit = (Unit)oldunits.get(0);
        Unit newunit = (Unit)newunits.get(0);
        if (oldunit.getClass() != newunit.getClass()) {
            this.Err("uncompatible change ", newunit);
            return;
        }
        if (oldunit instanceof UnitPack) {
            if (newunit.topname == oldunit.topname && newunit.name == oldunit.name) {
                this.Err("nothing to rename", oldunit);
            }
            this.units.add(newunit);
            this.tran.Transform(oldunit, newunit);
            this.RenameAll(oldunit.topname + oldunit.name, newunit.topname + newunit.name);
        } else if (oldunit instanceof UnitClass) {
            if (oldunits.size() != 1 || newunits.size() != 1) {
                this.Err("error ???");
            }
            this.units.add(newunit);
            this.tran.Transform(oldunit, newunit);
            if (newunit.topname != oldunit.topname || newunit.name != oldunit.name) {
                this.RenameAll(oldunit.topname + oldunit.name, newunit.topname + newunit.name);
            }
        } else {
            this.units.add(newunit);
            this.tran.Transform(oldunit, newunit);
        }
    }

    void RenameAll(String oldname, String newname) {
        Vector<Unit> temp = new Vector<Unit>();
        Enumeration e = this.units.elements();
        while (e.hasMoreElements()) {
            Unit u = (Unit)e.nextElement();
            if (!u.UsesType(oldname)) continue;
            Unit w = (Unit)u.clone();
            w.Rename(oldname, newname);
            this.tran.Transform(u, w);
            temp.addElement(w);
        }
        this.units.addAll(temp);
    }

    boolean ReadUnitNew(Units uu) {
        Units ww = new Units();
        if (!this.ReadUnit(ww, this.Topname())) {
            return false;
        }
        int i = 0;
        while (i < ww.size()) {
            Unit w = (Unit)ww.get(i);
            if (this.units.contains(w) || uu.contains(w)) {
                this.Err("duplicate name", w);
            } else {
                uu.add(w);
            }
            ++i;
        }
        return true;
    }

    boolean ReadUnitOld(Units uu) {
        Units ww = new Units();
        if (!this.ReadUnit(ww, this.Topname()) || ww.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < ww.size()) {
            Unit w = (Unit)ww.get(i);
            Unit u = this.units.Find(w);
            if (u == null) {
                this.Err("name not found", w);
            } else {
                uu.add(u);
            }
            ++i;
        }
        return true;
    }

    String Topname() {
        String s;
        String string = s = this.defpack == null ? "" : this.defpack + '.';
        if (this.defclass != null) {
            s = s + this.defclass + '.';
        }
        return s;
    }

    boolean Err(String m, Unit u) {
        ++this.errs;
        return super.Err(m, u);
    }

    void ErrCheck() {
        if (this.errs != 0) {
            System.err.println(this.tran.defstat.name + ", line " + this.tran.defstat.linenb);
        }
    }

    static {
        syn_UPDATE = 1000;
        syn_PACKAGE = 1001;
        syn_CLASS = 1002;
        syn_ADD = 1003;
        syn_DELETE = 1004;
        syn_CHANGE = 1005;
        syn_TO = 1006;
        syn_END = 1007;
        syn_INTERFACE = 1008;
        JReader.words.Put("#UPDATE", 1000);
        JReader.words.Put("#PACKAGE", 1001);
        JReader.words.Put("#CLASS", 1002);
        JReader.words.Put("#ADD", 1003);
        JReader.words.Put("#DELETE", 1004);
        JReader.words.Put("#CHANGE", 1005);
        JReader.words.Put("#TO", 1006);
        JReader.words.Put("#END", 1007);
        JReader.words.Put("#INTERFACE", 1008);
    }
}

