/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MemberCollection {
    private Set members = new HashSet();

    public void addMember(MemberDescription memberDescription) {
        if (MemberType.CLASS == memberDescription.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        this.members.add(memberDescription);
    }

    public void updateMember(MemberDescription memberDescription) {
        if (MemberType.CLASS == memberDescription.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        this.members.remove(memberDescription);
        this.members.add(memberDescription);
    }

    public Collection getAllMembers() {
        return this.members;
    }

    public boolean contains(MemberDescription memberDescription) {
        return this.members.contains(memberDescription);
    }

    public Iterator iterator() {
        return this.members.iterator();
    }

    public void changeMember(MemberDescription memberDescription, MemberDescription memberDescription2) {
        if (MemberType.CLASS == memberDescription2.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        if (!this.contains(memberDescription)) {
            throw new IllegalArgumentException("Member " + memberDescription + " not found!");
        }
        this.members.remove(memberDescription);
        this.members.add(memberDescription2);
    }

    public MemberDescription find(MemberDescription memberDescription) {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            MemberDescription memberDescription2 = (MemberDescription)iterator.next();
            if (!memberDescription2.equals(memberDescription)) continue;
            return memberDescription2;
        }
        return null;
    }

    public MemberDescription findSimilar(MemberDescription memberDescription) {
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            MemberDescription memberDescription2 = (MemberDescription)iterator.next();
            if (!memberDescription2.getType().equals(memberDescription.getType()) || !memberDescription2.getName().equals(memberDescription.getName())) continue;
            return memberDescription2;
        }
        return null;
    }

    public int getMembersCount(MemberType memberType, String string) {
        int n = 0;
        Iterator iterator = this.members.iterator();
        while (iterator.hasNext()) {
            MemberDescription memberDescription = (MemberDescription)iterator.next();
            if (memberType != null && memberType != memberDescription.getMemberType() || !string.equals(memberDescription.getQualifiedName())) continue;
            ++n;
        }
        return n;
    }
}

