/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.props;

import org.apache.ant.props.RegexBasedEvaluator;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;

public class ComponentTypeEvaluator
extends RegexBasedEvaluator {
    private static final Class[] PROJECT_STRING = new Class[]{Project.class, String.class};
    private static final Class[] STRING_ONLY = new Class[]{String.class};

    public ComponentTypeEvaluator() {
        super("^(.*?)\\((.*)\\)$");
    }

    protected Object evaluate(String[] groups, PropertyHelper propertyHelper) {
        Object result = null;
        Project p = propertyHelper.getProject();
        Class componentType = ComponentHelper.getComponentHelper((Project)p).getDefinition(groups[1]).getTypeClass(p);
        if (componentType != null) {
            try {
                result = componentType.getConstructor(PROJECT_STRING).newInstance(p, groups[2]);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                result = componentType.getConstructor(STRING_ONLY).newInstance(groups[2]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result != null) {
                p.setProjectReference(result);
            }
        }
        return result;
    }
}

