/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMerge {
    static final Logger lgr = Logger.getLogger(CMerge.class.getName());
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(CMerge.class);
    String oFile;
    String[] iFiles;
    boolean strict = false;
    CovDocument[] docs;
    public static final String STRICT_OPTION = "-Strict";
    Document result;
    Element resultReport;
    XPathFactory xPathfactory = XPathFactory.newInstance();

    public static void main(String[] args) {
        new CMerge().perform(args);
    }

    private void perform(String[] args) {
        if (this.parseParameters(args)) {
            this.perform();
        } else if (args.length > 0 && args[0].equalsIgnoreCase("-Version")) {
            lgr.severe(Version.getVersionInfo());
        } else {
            this.usage();
        }
    }

    private void perform() {
        this.docs = new CovDocument[this.iFiles.length];
        try {
            for (int i = 0; i < this.iFiles.length; ++i) {
                this.docs[i] = new CovDocument(this.iFiles[i]);
            }
            if (this.checkAndMerge(this.docs, this.strict)) {
                this.saveToXml(this.result, this.oFile);
            }
        }
        catch (SAXException ex) {
            lgr.log(Level.SEVERE, null, ex);
        }
        catch (TransformerConfigurationException ex) {
            lgr.log(Level.SEVERE, null, ex);
        }
        catch (TransformerException ex) {
            lgr.log(Level.SEVERE, null, ex);
        }
        catch (XPathExpressionException ex) {
            lgr.log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            lgr.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            lgr.log(Level.SEVERE, null, ex);
        }
    }

    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(nl).append(this.getComponentName()).append(" - ").append(i18n.getString("Merge.usage.version", "3.1"));
        sb.append(nl).append(i18n.getString("Merge.usage.start"));
        sb.append(nl).append(i18n.getString("Merge.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Merge.usage.files", "-Files"));
        sb.append(nl).append(i18n.getString("Merge.usage.write", "-Write"));
        sb.append(nl).append(i18n.getString("Merge.usage.strict", STRICT_OPTION));
        sb.append(nl).append(i18n.getString("Merge.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Merge.helpusage.version", "-Version"));
        sb.append(nl).append(i18n.getString("Merge.usage.help", "-Help"));
        sb.append(nl).append(i18n.getString("Merge.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Merge.usage.end"));
        System.err.println(sb.toString());
    }

    protected String getComponentName() {
        return "CoverageMerge";
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], "-Help") || parser.isOptionSpecified(args[0], "-?"))) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption("-Files", OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption("-Write", OptionInfo.option(1), "decodeOptions");
        parser.addOption(STRICT_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Help", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Version", OptionInfo.optionalFlag(), "decodeOptions");
        try {
            parser.processArgs(args);
            if (this.oFile != null) {
                this.checkValidWriteFile();
            }
        }
        catch (CommandLineParserException e) {
            System.err.println(e.getMessage());
            return false;
        }
        return true;
    }

    private void checkValidWriteFile() throws CommandLineParserException {
        File canonicalFile = null;
        try {
            canonicalFile = new File(this.oFile).getCanonicalFile();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.oFile));
        }
        for (int i = 0; i < this.iFiles.length; ++i) {
            try {
                File sigFile = new File(this.iFiles[i]).getCanonicalFile();
                if (!canonicalFile.equals(sigFile)) continue;
                throw new CommandLineParserException(i18n.getString("Merge.notunique.writefile"));
            }
            catch (IOException ex) {
                throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.iFiles[i]));
            }
        }
        try {
            FileOutputStream f = new FileOutputStream(this.oFile);
            f.close();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.create.write.file"));
        }
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase("-Files")) {
            StringTokenizer st = new StringTokenizer(args[0], File.pathSeparator);
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreElements()) {
                list.add(st.nextToken());
            }
            this.iFiles = list.toArray(new String[list.size()]);
        } else if (optionName.equalsIgnoreCase("-Write")) {
            this.oFile = args[0];
        } else if (optionName.equalsIgnoreCase(STRICT_OPTION)) {
            this.strict = true;
        }
    }

    private boolean checkAndMerge(CovDocument[] docs, boolean strict) throws XPathExpressionException, ParserConfigurationException {
        String[] keys = new String[]{"-excludeList", "-excludeInterfaces", "-excludeAbstractClasses", "-excludeAbstractMethods", "-excludeFields", "-includeConstantFields", "-mode"};
        HashMap<String, String> confs = new HashMap<String, String>();
        for (String string : keys) {
            confs.put(string, "NA");
        }
        for (CovDocument covDocument : docs) {
            for (String key : keys) {
                String m = covDocument.getConfigValue(key, "no");
                String o = (String)confs.get(key);
                if (o.equals(m)) continue;
                if (o.equals("NA")) {
                    confs.put(key, m);
                    continue;
                }
                System.err.println("Files contain incompatible heads for " + key);
                return false;
            }
        }
        this.result = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.resultReport = this.result.createElement("report");
        this.result.appendChild(this.resultReport);
        Element eHead = this.result.createElement("head");
        this.resultReport.appendChild(eHead);
        for (Map.Entry en : confs.entrySet()) {
            if (((String)en.getValue()).equals("NA")) continue;
            Element element = this.result.createElement("property");
            element.setAttribute("name", (String)en.getKey());
            element.setAttribute("value", (String)en.getValue());
            eHead.appendChild(element);
        }
        HashMap<String, Element[]> allClasses = new HashMap<String, Element[]>();
        for (int i = 0; i < docs.length; ++i) {
            CovDocument covDocument = docs[i];
            for (Element cl : covDocument.getClasses()) {
                String qName = covDocument.getQname(cl);
                if (!allClasses.containsKey(qName)) {
                    allClasses.put(qName, new Element[docs.length]);
                }
                ((Element[])allClasses.get((Object)qName))[i] = cl;
            }
        }
        for (Map.Entry entry : allClasses.entrySet()) {
            String qName = (String)entry.getKey();
            Element[] similarClasses = (Element[])entry.getValue();
            HashSet<String> atsG = null;
            NamedNodeMap classAttributes = null;
            for (Element c : similarClasses) {
                String m2;
                if (c == null) continue;
                classAttributes = c.getAttributes();
                HashSet<String> atsL = new HashSet<String>();
                for (int i = 0; i < classAttributes.getLength(); ++i) {
                    String aName = classAttributes.item(i).getNodeName();
                    String aVal = classAttributes.item(i).getNodeValue();
                    if (aName.equals("name") || aName.equals("members") || aName.equals("tested") || aName.equals("typeArgs")) continue;
                    atsL.add(aName);
                }
                if (atsG == null) {
                    atsG = atsL;
                    continue;
                }
                String m1 = atsG.toString();
                if (m1.equals(m2 = atsL.toString())) continue;
                System.err.println("Incompatible attributes for class " + qName + ":");
                System.err.println(m1 + " and " + m2);
                return false;
            }
            HashMap<String, Element> members = new HashMap<String, Element>();
            boolean firstTime = true;
            for (Element classElement : similarClasses) {
                if (classElement == null) continue;
                NodeList memberList = classElement.getChildNodes();
                for (int i = 0; i < memberList.getLength(); ++i) {
                    String m2;
                    boolean isCov;
                    Node n = memberList.item(i);
                    if (!(n instanceof Element)) continue;
                    Element member = (Element)n;
                    String memberID = member.getNodeName() + " " + member.getAttribute("name") + " " + member.getAttribute("sig");
                    String myAttrsToCheck = this.getMemberModifsAsString(member);
                    boolean bl = isCov = Integer.parseInt(member.getAttribute("tested")) > 0;
                    if (firstTime) {
                        members.put(memberID, member);
                        if (i != memberList.getLength() - 1) continue;
                        firstTime = false;
                        continue;
                    }
                    if (strict && !members.containsKey(memberID)) {
                        System.err.println("Different members in class class " + qName);
                        System.err.println("Member " + memberID);
                        return false;
                    }
                    if (!members.containsKey(memberID)) {
                        members.put(memberID, member);
                        continue;
                    }
                    String m1 = this.getMemberModifsAsString((Element)members.get(memberID));
                    if (!m1.equals(m2 = myAttrsToCheck)) {
                        System.err.println("Incompatible member attributes in class " + qName);
                        System.err.println("member " + memberID);
                        System.err.println(m1 + " and " + m2);
                        return false;
                    }
                    if (!isCov) continue;
                    Element stored = (Element)members.get(memberID);
                    stored.setAttribute("tested", "1");
                }
            }
            this.addClass(qName, classAttributes, members.values());
        }
        return true;
    }

    private String getMemberModifsAsString(Element member) {
        HashSet<String> modifS = new HashSet<String>();
        NamedNodeMap attrs = member.getAttributes();
        for (int j = 0; j < attrs.getLength(); ++j) {
            String aName = attrs.item(j).getNodeName();
            if (aName.equals("name") || aName.equals("type") || aName.equals("sig") || aName.equals("tested") || aName.equals("vmsig")) continue;
            modifS.add(aName);
        }
        return modifS.toString();
    }

    private void saveToXml(Document d, String oFile) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(d);
        StreamResult sresult = new StreamResult(new File(oFile));
        transformer.transform(source, sresult);
    }

    private void addClass(String qName, NamedNodeMap classAttributes, Collection<Element> members) {
        try {
            Element pck = this.createPackagesFor(qName);
            Element cl = this.result.createElement("class");
            for (int i = 0; i < classAttributes.getLength(); ++i) {
                String aName = classAttributes.item(i).getNodeName();
                String aVal = classAttributes.item(i).getNodeValue();
                cl.setAttribute(aName, aVal);
            }
            int memberCount = 0;
            int testedCount = 0;
            for (Element member : members) {
                Element newM = this.result.createElement(member.getNodeName());
                NamedNodeMap membAttributes = member.getAttributes();
                for (int i = 0; i < membAttributes.getLength(); ++i) {
                    String aName = membAttributes.item(i).getNodeName();
                    String aVal = membAttributes.item(i).getNodeValue();
                    newM.setAttribute(aName, aVal);
                    if (!aName.equals("tested") || !aVal.equals("1")) continue;
                    ++testedCount;
                }
                cl.appendChild(newM);
                cl.setAttribute("members", "" + ++memberCount);
                cl.setAttribute("tested", "" + testedCount);
            }
            pck.appendChild(cl);
            this.updateCounters(pck, memberCount, testedCount);
        }
        catch (XPathExpressionException ex) {
            lgr.log(Level.SEVERE, null, ex);
        }
    }

    private Element createPackagesFor(String qName) throws XPathExpressionException {
        StringTokenizer st = new StringTokenizer(qName, ".");
        int parts = st.countTokens();
        String path = "/report/package[@name='']";
        Element packageE = this.checkForPackage(path, "", this.resultReport);
        for (int pn = 1; st.hasMoreTokens() && pn < parts; ++pn) {
            String pnm = st.nextToken().trim();
            path = path + "/" + "package" + "[@" + "name" + "='" + pnm + "']";
            packageE = this.checkForPackage(path, pnm, packageE);
        }
        return packageE;
    }

    private Element checkForPackage(String path, String name, Element parentPkg) throws XPathExpressionException {
        XPath xpath = this.xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(path);
        Element par = (Element)expr.evaluate(this.result, XPathConstants.NODE);
        if (par == null) {
            par = this.result.createElement("package");
            par.setAttribute("name", name);
            par.setAttribute("members", "0");
            par.setAttribute("tested", "0");
            parentPkg.appendChild(par);
        }
        return par;
    }

    private void updateCounters(Element pck, int memberCount, int testedCount) {
        Element p = pck;
        while (p.getNodeName().equals("package")) {
            int count = Integer.parseInt(p.getAttribute("members")) + memberCount;
            int tested = Integer.parseInt(p.getAttribute("tested")) + testedCount;
            p.setAttribute("members", "" + count);
            p.setAttribute("tested", "" + tested);
            p = (Element)p.getParentNode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CovDocument {
        DocumentBuilder builder;
        Document doc;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        String fileName;

        public CovDocument(String fileName) throws ParserConfigurationException, SAXException, IOException {
            this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.doc = this.builder.parse(fileName);
            this.fileName = fileName;
        }

        public String getConfigValue(String key, String def) throws XPathExpressionException {
            XPath xpath = this.xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("/report/head/property");
            NodeList nl = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element h = (Element)nl.item(i);
                if (!h.getAttribute("name").equals(key)) continue;
                String v = h.getAttribute("value");
                if (v == null || "".equals(v)) {
                    return def;
                }
                return v;
            }
            return def;
        }

        private Set<Element> getClasses() throws XPathExpressionException {
            return this.getElementsByKind("class");
        }

        private Set<Element> getElementsByKind(String name) throws XPathExpressionException {
            HashSet<Element> result = new HashSet<Element>();
            XPath xpath = this.xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//" + name);
            NodeList nl = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                result.add((Element)nl.item(i));
            }
            return result;
        }

        private String getQname(Element e) {
            String pName;
            Element p;
            Node parentNode;
            String qName = e.getAttribute("name");
            Element currNode = e;
            while ((parentNode = currNode.getParentNode()) != null && parentNode instanceof Element && ((p = (Element)parentNode).getNodeName().equals("package") || p.getNodeName().equals("class")) && !"".equals(pName = p.getAttribute("name"))) {
                qName = pName + "." + qName;
                currNode = p;
            }
            return qName;
        }
    }
}

