/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.AbstractCalendarFormatter;
import com.sun.msv.datatype.xsd.datetime.BigDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;

public class PreciseCalendarFormatter
extends AbstractCalendarFormatter {
    private static final PreciseCalendarFormatter theInstance = new PreciseCalendarFormatter();

    private PreciseCalendarFormatter() {
    }

    private void formatTwoDigits(Integer v, int offset, StringBuffer buf) {
        if (v == null) {
            buf.append("00");
        } else {
            this.formatTwoDigits(v + offset, buf);
        }
    }

    private void formatTwoDigits(Integer v, StringBuffer buf) {
        this.formatTwoDigits(v, 0, buf);
    }

    protected void formatDays(Object cal, StringBuffer buf) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getDay(), 1, buf);
    }

    protected void formatHours(Object cal, StringBuffer buf) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getHour(), buf);
    }

    protected void formatMinutes(Object cal, StringBuffer buf) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getMinute(), buf);
    }

    protected void formatMonth(Object cal, StringBuffer buf) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getMonth(), 1, buf);
    }

    /*
     * Unable to fully structure code
     */
    protected void formatSeconds(Object cal, StringBuffer buf) {
        bv = ((IDateTimeValueType)cal).getBigValue();
        sec = bv.getSecond();
        if (sec != null) ** GOTO lbl8
        buf.append("00");
        return;
lbl-1000:
        // 1 sources

        {
            sec = sec.movePointLeft(1);
lbl8:
            // 2 sources

            ** while (sec.scale() > 0 && sec.toString().endsWith((String)"0"))
        }
lbl9:
        // 1 sources

        s = sec.toString();
        if (sec.compareTo(new BigDecimal("10")) < 0) {
            s = "0" + s;
        }
        buf.append(s);
    }

    protected void formatYear(Object cal, StringBuffer buf) {
        String s;
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        BigInteger year = bv.getYear();
        if (year == null) {
            buf.append("0000");
            return;
        }
        if (year.signum() <= 0) {
            buf.append('-');
            s = year.negate().add(BigInteger.ONE).toString();
        } else {
            s = year.toString();
        }
        while (s.length() < 4) {
            s = "0" + s;
        }
        buf.append(s);
    }

    protected Calendar toCalendar(Object cal) {
        return ((BigDateTimeValueType)cal).toCalendar();
    }

    public static String format(String format, IDateTimeValueType cal) {
        return theInstance.doFormat(format, cal.getBigValue());
    }
}

