/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Session;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getProperty(String)</strong> API.
 * It does this by passing various valid input values and then checking
 * the return type and value. Returns null if this property does not exist. <p>
 *
 *		Returns the value of the specified property. <p>
 * api2test: public String getProperty(String name) <p>
 *
 * how2test: Call this API with various string parameters. Check that it <p>
 *	     returns a string value. <p> 
 *
 * Input:    	api parameter               | return   <p>
 *          ---------------------------------------------  <p>
 *          mail.protocol.host              | string value <p>
 *	    mail.protocol.user              | string value <p>
 *	    mail.store.protocol	            | string value
 */

public class getProperty_Test extends MailTest {

    public static void main( String argv[] )
    {
        getProperty_Test test = new getProperty_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Session: getProperty()\n");
	String propis = null;
	
        try {
	   // Get properties object
              Properties props = new Properties();
              props.put("mail."+ protocol +".user", "testuser");
              props.put("mail."+ protocol +".host", "localhost");
	      props.put("mail.store.protocol", protocol);

	   // Create a Session object
	      Session session = Session.getInstance(props, null);

	      if( session == null ) {
		  return Status.failed("Warning: null session object!");
	      }
           // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1: getProperty(mail."+ protocol +".host)");
              propis = session.getProperty("mail."+ protocol +".host");	    // API TEST

              if ( propis != null && propis.equals("localhost") ) {
                  out.println("UNIT TEST 1:  passed\n");
              } else {
		     out.println("The value returned is: "+ propis);
                     out.println("UNIT TEST 1:  FAILED\n");
                     errors++;
              }
           // END UNIT TEST 1:
           // BEGIN UNIT TEST 2:
              out.println("UNIT TEST 2: getProperty(mail."+ protocol +".user)");
              propis = session.getProperty("mail."+ protocol +".user");	    // API TEST

              if( propis != null && propis.equals("testuser") ) {
		  out.println("The value returned is: "+ propis);
                  out.println("UNIT TEST 2:  passed\n");
              } else {
                      out.println("UNIT TEST 2:  FAILED\n");
                      errors++;
              }
           // END UNIT TEST 2:
           // BEGIN UNIT TEST 3:
              out.println("UNIT TEST 3: getProperty(mail.store.protocol)");
              propis = session.getProperty("mail.store.protocol");	    // API TEST

              if( propis != null && propis.equals(protocol) ) {
		  out.println("The value returned is: "+ propis);
                  out.println("UNIT TEST 3:  passed\n");
              } else {
                      out.println("UNIT TEST 3:  FAILED\n");
                      errors++;
              }
           // END UNIT TEST 3:
              checkStatus();

        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
