/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Message;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>isSet()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	Check whether the flag(s) specified in the given Flags object are set
 *	in this Message.<p>
 * api2test: public boolean isSet(Flags)  <p>
 *
 * how2test: Call this API for given Flags object. If its set it returns true, otherwise
 *	     a false. Regardless, this testcase passes.
 */

public class isSet_Test extends MailTest {

    public static void main( String argv[] )
    {
        isSet_Test test = new isSet_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Message: isSet(Flags)\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if ( folder == null ) {
                  return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }
	     boolean iset1, iset2;

             for( int i = 1; i <= msgcount; i++ )
             {
             // Get the message
                MimeMessage msg = (MimeMessage)folder.getMessage(i);

	        if( msg == null ) {
		    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
		    continue;
	        }
	     // BEGIN UNIT TEST:
		// Returns the flags associated with this message
	        out.println("UNIT TEST "+ i +":  isSet(Flags)");

	        Flags msgflag = msg.getFlags();
	        iset1 = msg.isSet(Flags.Flag.SEEN);		// API TEST
		iset2 = msg.isSet(Flags.Flag.ANSWERED);		// API TEST

	        if( iset1 && iset2 )
                    out.println("UNIT TEST "+ i +":  passed\n");
	        else {
		      out.println("Caution: The flags for message object is not set!");
		      out.println("UNIT TEST "+ i +":  passed\n");
	        }
	     // END UNIT TEST:
	     }
	     folder.close(false);
	     store.close();
	     status = Status.passed("OKAY");

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
