/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Message;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getMatchingHeaders()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	Return matching headers from this part as an Enumeration of Header objects.<p>
 * api2test: public Enumeration getMatchingHeaders(String[])  <p>
 *
 * how2test: Call this API with desired header strings, verify that it returns a list of <p>
 *	     matching headers. Write out this list to stdio. If this operation is a success,
 *	     then this testcase passes, otherwise it fails.
 */

public class getMatchingHeaders_Test extends MailTest {

    public static String[] headerlist = { "Return-Path","Message-ID","Date","From","Reply-To",
                                          "X-Mailer","MIME-Version","To","Cc","Subject",
                                          "Content-Type","Content-Transfer-Encoding",
                                          "Content-MD5","Content-Length"
                                        };

    public static void main( String argv[] )
    {
        getMatchingHeaders_Test test = new getMatchingHeaders_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Message: getMatchingHeaders(String[])\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if ( folder == null ) {
                  return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }

             for(int i = 1; i <= msgcount; i++)
             {
             // Get the message
                Message msg = folder.getMessage(i);

	        if( msg == null ) {
		    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
		    continue;
	        }
	     // BEGIN UNIT TEST:
		// Get matching headers for given message(s)
	        out.println("UNIT TEST "+ i +":  getMatchingHeaders(String[])");

	        Enumeration matcheaders = msg.getMatchingHeaders(headerlist);	// API TEST

	        while( matcheaders.hasMoreElements() ) {
		       Header headers = (Header)matcheaders.nextElement();
		       out.println(headers.getName());
	        }
                out.println("UNIT TEST "+ i +":  passed\n");
	     // END UNIT TEST:
	     }
	     folder.close(false);
	     store.close();
	     status = Status.passed("OKAY");

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
