/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Folder;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>isOpen()</strong> API.
 * It does this by invoking the api under test and then checking
 * the value of the returned object.	<p>
 *
 *		Indicates whether this Folder is in the 'open' state  <p>
 * api2test: public boolean isOpen()  <p>
 *
 * how2test: Call this API on an open or closed folder. If it returns a value <p>
 *	     of TRUE then the folder is open and closed otherwise. In either <p>
 *	     case the testcase is considered passing. Test this against closed
 *	     and open folder.
 */

public class isOpen_Test extends MailTest {

    public static void main( String argv[] )
    {
        isOpen_Test test = new isOpen_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Folder: isOpen()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if( folder == null ) {
	         return Status.failed("Invalid folder object!");
       	     }
	  // BEGIN UNIT TEST 1:
	     // test with closed folder
             out.println("UNIT TEST 1: isOpen();");

             boolean isOpen = folder.isOpen(); 	// API TEST
	     
             if( !( isOpen ) ) {
		 out.println("This folder is not open.");
                 out.println("UNIT TEST 1: passed\n");
             }
	  // END UNIT TEST 1:
          // BEGIN UNIT TEST 2:
	     // test with open folder

	     folder.open(Folder.READ_ONLY);
             out.println("UNIT TEST 2: isOpen();");

             isOpen = folder.isOpen();       // API TEST

             if( isOpen ) {
                 out.println("This folder is open.");
                 out.println("UNIT TEST 2: passed\n");
             }
          // END UNIT TEST 2:
	     folder.close(false);
	     store.close();
	     checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
