/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: AppManagedNoTxVehicleBean.java 63072 2011-06-15 14:46:08Z sdimilla $
 */

package com.sun.ts.tests.common.vehicle.appmanagedNoTx;

import com.sun.ts.lib.harness.RemoteStatus;
import com.sun.ts.tests.common.vehicle.ejb3share.EntityTransactionWrapper;

import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceUnit;
import java.util.Properties;

@Stateful(name="AppManagedNoTxVehicleBean")
@Remote({AppManagedNoTxVehicleIF.class})        
public class AppManagedNoTxVehicleBean 
        extends com.sun.ts.tests.common.vehicle.ejb3share.EJB3ShareBaseBean
        implements AppManagedNoTxVehicleIF, java.io.Serializable {
    
    public AppManagedNoTxVehicleBean() {
        super();
    }
    
    protected  String getVehicleType() { return APPMANAGEDNOTX; }
    private EntityManagerFactory emf;
    
   //================== business methods ====================================
    @Remove
    public RemoteStatus runTest(String[] args, Properties props) {
        props.put("persistence.unit.name","CTS-EM-NOTX");
        try {
            setEntityManager(emf.createEntityManager());
        	RemoteStatus retValue;     
        	retValue = super.runTest(args, props);
        	return retValue;
	} finally {
          try {
		if ( getEntityManager().isOpen() ) {	
		     getEntityManager().close();
		}
	  } catch (Exception e) {
 	    System.out.println("Exception caught during em.close()" +e);
	  }
        }	 	
    }
    /////////////////////////////////////////////////////////////////////////

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PersistenceUnit(unitName="CTS-EM-NOTX")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
        this.entityManagerFactory = emf;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected EntityTransaction getEntityTransaction() {
 	return new EntityTransactionWrapper(getEntityManager().getTransaction());
    }
}
