/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.javatest.Command;
import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.StringArray;
import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.deliverable.PropertyNotSetException;
import com.sun.ts.lib.harness.ExecutionMode;
import com.sun.ts.lib.harness.ProfileHelper;
import com.sun.ts.lib.harness.SuiteSynchronizer;
import com.sun.ts.lib.harness.TSTestFinder;
import com.sun.ts.lib.porting.TSDeploymentInterface;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.condition.Os;

public class TSScript
extends Script {
    TestResult.Section section;
    Status status;
    TestResult testResult;
    String keywords;
    PrintWriter logOut;
    private static String sClientClassesPath = "";
    private static SuiteSynchronizer ss;
    String testDir = "";
    String sVehicle = "";
    String sIsServiceTest = "";
    Properties pTestProps;
    PropertyManagerInterface propMgr;
    boolean bAppClientTest;
    int executionMode;
    Properties pExecProps = new Properties();
    public static boolean bUseSameJVMCommand;
    private String sInteropDirection;
    private boolean bIsRebuildableReverseTest = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        Object fClassesVIBuiltDir;
        this.pTestProps = new Properties();
        Object sArgs = null;
        Object sVal = null;
        String testName = td.getParameter("testName");
        String executeClass = td.getParameter("classname");
        String executeArgs = td.getParameter("testArgs");
        String sTestJteFile = null;
        String sSrcDir = TSTestFinder.getAbsolutePath(td.getParameter("test_directory"));
        String sClassesVIBuiltDir = TestUtil.replaceLastSrc(sSrcDir, "classes_vi_built");
        this.testDir = TestUtil.srcToDist(sSrcDir);
        this.testResult = this.getTestResult();
        this.section = this.testResult.createSection("TestRun");
        this.logOut = this.section.createOutput("log");
        this.sInteropDirection = td.getParameter("direction");
        if (this.sInteropDirection == null) {
            this.sInteropDirection = "forward";
        }
        if (this.testDir.indexOf("interop") == -1 && this.sInteropDirection.equals("reverse")) {
            this.bIsRebuildableReverseTest = true;
            fClassesVIBuiltDir = new File(sClassesVIBuiltDir);
            String[] sVIBuiltClasses = ((File)fClassesVIBuiltDir).list(ClassFilter.getInstance());
            if (sVIBuiltClasses == null || sVIBuiltClasses.length == 0) {
                String error = "TEST NOT RUN:  This test cannot be run until you" + TestUtil.NEW_LINE + "rebuild the test classes and/or archives associated with it." + TestUtil.NEW_LINE + "Please see the TCK documentation for more" + TestUtil.NEW_LINE + "information on rebuildable tests.";
                this.logOut.println("*********************************************");
                this.logOut.println(error);
                this.logOut.println("*********************************************");
                return Status.error("VI classes and/or archives have not been built.");
            }
        }
        try {
            Object vehicleArchiveName;
            this.propMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            this.keywords = this.propMgr.getProperty("current.keywords");
            this.propMgr = DeliverableFactory.getDeliverableInstance().createPropertyManager(env);
            ss = SuiteSynchronizer.getSuiteSynchronizer(this.logOut);
            this.executionMode = ExecutionMode.getExecutionMode(this.propMgr);
            if (this.executionMode == 5) {
                this.logOut.println("TEST:  " + testName);
                fClassesVIBuiltDir = Status.error("LISTED");
                return fClassesVIBuiltDir;
            }
            if (this.executionMode == 1) {
                if (ss.getDeploymentStatus().equals("failed")) {
                    this.logOut.println(ss.getDeploymentExceptionTrace());
                    fClassesVIBuiltDir = Status.failed("An error occurred during the Deployment phase for tests in this directory.");
                    return fClassesVIBuiltDir;
                }
                fClassesVIBuiltDir = Status.passed("DEPLOYED");
                return fClassesVIBuiltDir;
            }
            if (this.executionMode == 3) {
                if (ss.getDeploymentStatus().equals("failed")) {
                    this.logOut.println(ss.getDeploymentExceptionTrace());
                    fClassesVIBuiltDir = Status.failed("An error occurred during the Deployment phase for tests in this directory.");
                    return fClassesVIBuiltDir;
                }
                fClassesVIBuiltDir = Status.passed("UNDEPLOYED");
                return fClassesVIBuiltDir;
            }
            ss.swapSettings("forward");
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("TSScript - sInteropDirection:  " + this.sInteropDirection);
            }
            if (this.sInteropDirection.equals("reverse")) {
                ss.swapSettings("reverse");
                if (TestUtil.harnessDebug) {
                    TestUtil.logHarnessDebug("Reversed settings for test:  " + testName);
                }
            }
            if (TestUtil.harnessDebug) {
                StringBuffer sb = new StringBuffer();
                sb.append("test description contains key/value:");
                Iterator e = td.getParameterKeys();
                while (e.hasNext()) {
                    String k = (String)e.next();
                    sb.append(k).append('=').append(td.getParameter(k));
                }
                TestUtil.logHarnessDebug(sb.toString());
            }
            String sTemp = "";
            String sTempArgs = "";
            String defaultBin = System.getProperty("TS_HOME") + File.separator + "bin";
            String sTSBinDir = System.getProperty("bin.dir", defaultBin);
            if (executeArgs != null) {
                StringTokenizer st = new StringTokenizer(executeArgs);
                while (st.hasMoreTokens()) {
                    sTemp = st.nextToken();
                    if (sTemp.equals("-ap")) {
                        String next = st.nextToken();
                        if (next.equals("tssql.stmt") && this.sInteropDirection.equals("reverse")) {
                            sTempArgs = sTempArgs + sTemp + " " + sTSBinDir + File.separator + "tssql.stmt.ri ";
                            continue;
                        }
                        sTempArgs = sTempArgs + sTemp + " " + sTSBinDir + File.separator + next + " ";
                        continue;
                    }
                    sTempArgs = sTempArgs + sTemp + " ";
                }
                executeArgs = sTempArgs.trim();
            }
            String testPropsInDescp = td.getParameter("testProps");
            String[] sTestPropKeys = TestUtil.EMPTY_STRING_ARRAY;
            if (testPropsInDescp != null) {
                StringTokenizer st = new StringTokenizer(testPropsInDescp.trim());
                sTestPropKeys = new String[st.countTokens()];
                for (int ii = 0; ii < sTestPropKeys.length; ++ii) {
                    sTestPropKeys[ii] = st.nextToken();
                }
            }
            try {
                this.pTestProps = this.propMgr.getTestSpecificProperties(sTestPropKeys);
            }
            catch (PropertyNotSetException pnse) {
                pnse.printStackTrace();
                Status ii = Status.failed("Please supply values for the necessary properties to run these tests.  " + pnse.getMessage());
                if (this.logOut != null) {
                    this.logOut.close();
                }
                return ii;
            }
            TestUtil.logHarness("keywords (to be passed to tests) set to:  " + this.keywords);
            this.pTestProps.put("current.keywords", this.keywords);
            String finderType = td.getParameter("finder");
            this.pTestProps.put("finder", finderType == null ? "cts" : finderType);
            this.pTestProps.put("test_classname", executeClass);
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("** for JCK::testClassName= " + executeClass);
            }
            String sID = td.getParameter("id");
            this.sIsServiceTest = td.getParameter("service_eetest");
            this.sVehicle = null;
            if (this.sIsServiceTest.equals("yes")) {
                if (sID.endsWith("_reverse")) {
                    this.sVehicle = sID.substring(0, sID.lastIndexOf("_"));
                    this.sVehicle = this.sVehicle.substring(this.sVehicle.lastIndexOf("_") + 1);
                } else {
                    this.sVehicle = sID.substring(sID.lastIndexOf("_") + 1);
                }
                executeClass = this.sVehicle.equalsIgnoreCase("wsappclient") ? "com.sun.ts.tests.common.vehicle.wsappclient.WSAppclient" : "com.sun.ts.tests.common.vehicle.VehicleClient";
                if (TestUtil.harnessDebug) {
                    TestUtil.logHarnessDebug("sVehicle = " + this.sVehicle);
                }
                if (this.sVehicle.indexOf("servlet") != -1 || this.sVehicle.indexOf("connectorservlet") != -1 || this.sVehicle.indexOf("customvehicle") != -1 || this.sVehicle.indexOf("web") != -1 || this.sVehicle.indexOf("jsp") != -1 || this.sVehicle.indexOf("jsf") != -1) {
                    try {
                        this.pTestProps.put("webServerHost", this.propMgr.getProperty("webServerHost"));
                        this.pTestProps.put("webServerPort", this.propMgr.getProperty("webServerPort"));
                    }
                    catch (PropertyNotSetException e) {
                        e.printStackTrace();
                        Status status = Status.failed("Please supply values for webServerHost & webServerPort.  They are required to run service tests in a jsp or servlet.");
                        if (this.logOut != null) {
                            this.logOut.close();
                        }
                        return status;
                    }
                }
                if (!(this.sVehicle.equals("standalone") || this.sVehicle.equals("ejbembed") || this.sVehicle.equals("customvehicle") || this.sVehicle.equals("jbi"))) {
                    vehicleArchiveName = this.getVehicleArchiveName();
                    if (vehicleArchiveName == null) {
                        String msg = "TSScript:  No vehicle ear found in : \"" + this.testDir + "\".  If this is a test that requires test clients to be built before executing the tests, please refer to the TCK documentation for further instructions.";
                        TestUtil.logErr(msg);
                        Status status = Status.failed(msg);
                        return status;
                    }
                    this.pTestProps.put("vehicle_archive_name", vehicleArchiveName);
                }
            } else {
                this.sVehicle = "not a service test";
            }
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("sVehicle = " + this.sVehicle);
            }
            if (!this.sVehicle.equals("standalone") && !this.sVehicle.equals("jbi")) {
                if (ss.getDeploymentStatus().equals("failed")) {
                    System.err.println("*************test args = " + executeArgs);
                    if (executeArgs.contains("-expectdeploymentfailure")) {
                        this.logOut.println("Deployment failed as expected");
                        vehicleArchiveName = Status.passed("Deployment failed as expected");
                        return vehicleArchiveName;
                    }
                    this.logOut.println(ss.getDeploymentExceptionTrace());
                    vehicleArchiveName = Status.failed("An error occurred during the Deployment phase for tests in this directory.");
                    return vehicleArchiveName;
                }
                sClientClassesPath = ss.getClientClassPath();
            }
            try {
                sTestJteFile = this.createTestPropertyFile(this.pTestProps);
            }
            catch (Exception e) {
                Status msg = Status.failed("TSScript:  Failed to create tstest.jte file");
                if (this.logOut != null) {
                    this.logOut.close();
                }
                return msg;
            }
            executeArgs = this.sVehicle.equals("not a service test") ? (executeArgs == null ? "-p " + sTestJteFile + " -t " + testName : executeArgs + " -p " + sTestJteFile + " -t " + testName) : (executeArgs == null ? "-p " + sTestJteFile + " -t " + testName + " -vehicle " + this.sVehicle : " -p " + sTestJteFile + " -t " + testName + " -vehicle " + this.sVehicle + " " + executeArgs);
            String sClientEar = this.getClientEarFile();
            if (this.sVehicle.equalsIgnoreCase("ejbembed")) {
                if (TestUtil.harnessDebug) {
                    TestUtil.logHarnessDebug("testExecuteejbembed used");
                }
                this.pExecProps = new Properties();
                this.pExecProps.put("clientClasspath", TestUtil.srcToDist(this.testDir) + File.separator + "ejbembed_vehicle_ejb.jar");
                this.status = this.execute("testExecuteEjbEmbed", executeClass, executeArgs);
            } else if (sClientEar == null || this.sVehicle.equals("standalone") || this.sVehicle.indexOf("customvehicle") != -1 || this.sVehicle.indexOf("connectorservlet") != -1 || this.sVehicle.indexOf("servlet") != -1 || this.sVehicle.indexOf("web") != -1 || this.sVehicle.indexOf("jsp") != -1 || this.sVehicle.indexOf("jsf") != -1) {
                this.bAppClientTest = false;
                if (bUseSameJVMCommand) {
                    TestUtil.logHarness("Running test client in SameJVM mode");
                    this.status = this.execute("testExecuteSameJVM", executeClass, executeArgs);
                } else if (this.sInteropDirection.equals("reverse")) {
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("testExecute2 used");
                    }
                    this.status = this.execute("testExecute2", executeClass, executeArgs);
                } else {
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("testExecute used");
                    }
                    this.status = this.execute("testExecute", executeClass, executeArgs);
                }
            } else {
                this.bAppClientTest = true;
                this.pExecProps = new Properties();
                this.pExecProps.put("executeArgs", executeArgs);
                this.pExecProps.put("ear_file", sClientEar);
                this.pExecProps.put("clientClasspath", sClientClassesPath);
                if (sClientEar.indexOf("_vehicles") != -1) {
                    this.pExecProps.put("client_name", sClientEar.substring(sClientEar.lastIndexOf(File.separator) + 1, sClientEar.indexOf("_vehicles")) + "_" + this.sVehicle + "_vehicle_client");
                } else {
                    this.pExecProps.put("client_name", sClientEar.substring(sClientEar.lastIndexOf(File.separator) + 1, sClientEar.lastIndexOf(".")) + "_client");
                }
                this.pExecProps.put("test_classname", executeClass);
                TSDeploymentInterface ctsDeploy = null;
                if (sClientEar.indexOf("_j2ee2") != -1 || sClientEar.startsWith("vi_built_")) {
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("ss.getTSDeployer = cts2");
                    }
                    ctsDeploy = ss.getTSDeployer("cts2");
                } else {
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("ss.getTSDeployer = cts1");
                    }
                    ctsDeploy = ss.getTSDeployer("cts1");
                }
                if (this.sInteropDirection.equals("reverse")) {
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("testExecuteAppClient2 used");
                    }
                    this.status = this.execute("testExecuteAppClient2", "this.is.specified.in.the.jte.file", ctsDeploy.getAppClientArgs(this.pExecProps));
                } else {
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("testExecuteAppClient used");
                    }
                    this.status = this.execute("testExecuteAppClient", "this.is.specified.in.the.jte.file", ctsDeploy.getAppClientArgs(this.pExecProps));
                }
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            this.status = Status.failed("Can't load test: required interface not found");
        }
        catch (Exception e) {
            this.status = Status.failed("Illegal access to test: " + e);
            e.printStackTrace();
        }
        finally {
            if (this.logOut != null) {
                this.logOut.close();
            }
        }
        this.section.setStatus(this.status);
        return this.status;
    }

    private String getVehicleArchiveName() {
        String[] sAppJarsArray = ProfileHelper.getArchives(TestUtil.srcToDist(this.testDir), this.sInteropDirection);
        if (sAppJarsArray == null) {
            sAppJarsArray = TestUtil.EMPTY_STRING_ARRAY;
        }
        String vehicleName = null;
        if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("testdir = " + this.testDir);
        }
        if (this.sIsServiceTest.equals("yes")) {
            vehicleName = this.getVehicleArchiveName0(sAppJarsArray, ".ear");
            if (vehicleName == null) {
                vehicleName = this.getVehicleArchiveName0(sAppJarsArray, ".war");
            }
            if (vehicleName == null) {
                vehicleName = this.getVehicleArchiveName0(sAppJarsArray, ".jar");
            }
        }
        return vehicleName;
    }

    private String getVehicleArchiveName0(String[] archiveNames, String archiveExt) {
        String vehicleArchiveName = null;
        for (int ii = 0; ii < archiveNames.length; ++ii) {
            if (TestUtil.harnessDebug) {
                TestUtil.logHarnessDebug("archiveNames[ii] = " + archiveNames[ii]);
            }
            if (archiveNames[ii].indexOf("_vehicles") == -1 && archiveNames[ii].indexOf(this.sVehicle + "_vehicle") == -1 || !archiveNames[ii].endsWith(archiveExt)) continue;
            vehicleArchiveName = archiveNames[ii].startsWith("vi_built_") ? archiveNames[ii].substring(9, archiveNames[ii].lastIndexOf(archiveExt)) : archiveNames[ii].substring(0, archiveNames[ii].lastIndexOf(archiveExt));
            if (!TestUtil.harnessDebug) break;
            TestUtil.logHarnessDebug("vehicleArchiveName = " + vehicleArchiveName);
            break;
        }
        return vehicleArchiveName;
    }

    private String getClientEarFile() {
        File fTestDir = new File(TestUtil.srcToDist(this.testDir));
        if (!fTestDir.exists()) {
            return null;
        }
        String[] sAppJarsArray = ProfileHelper.getArchives(TestUtil.srcToDist(this.testDir), this.sInteropDirection);
        Enumeration<JarEntry> entries = null;
        String sEntry = null;
        String sAppClientEar = null;
        JarFile earFile = null;
        Object sRuntimeFileName = null;
        if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("testdir = " + this.testDir);
        }
        try {
            for (int ii = 0; ii < sAppJarsArray.length && sAppClientEar == null; ++ii) {
                if (this.bIsRebuildableReverseTest && sAppJarsArray[ii].indexOf("vi_built_") == -1 || !this.bIsRebuildableReverseTest && sAppJarsArray[ii].indexOf("vi_built_") != -1) continue;
                if (TestUtil.harnessDebug) {
                    TestUtil.logHarnessDebug("earFile = " + this.testDir + File.separator + sAppJarsArray[ii]);
                }
                if (this.sIsServiceTest.equals("yes")) {
                    if (sAppJarsArray[ii].indexOf("_vehicles") == -1 && sAppJarsArray[ii].indexOf(this.sVehicle + "_vehicle") == -1) continue;
                    sAppClientEar = this.testDir + File.separator + sAppJarsArray[ii];
                } else {
                    if (sAppJarsArray[ii].endsWith(".ear")) {
                        earFile = new JarFile(this.testDir + File.separator + sAppJarsArray[ii]);
                        entries = earFile.entries();
                        while (entries.hasMoreElements()) {
                            sEntry = entries.nextElement().getName();
                            if (sEntry.indexOf("_client.jar") == -1) continue;
                            sAppClientEar = this.testDir + File.separator + sAppJarsArray[ii];
                            break;
                        }
                        try {
                            if (earFile != null) {
                                earFile.close();
                            }
                            earFile = null;
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace(this.logOut);
                        }
                        continue;
                    }
                    if (!sAppJarsArray[ii].endsWith("_client.jar")) continue;
                    sAppClientEar = this.testDir + File.separator + sAppJarsArray[ii];
                }
                break;
            }
        }
        catch (IOException e) {
            this.logOut.println("Error trying to read ear files");
            e.printStackTrace();
        }
        return sAppClientEar;
    }

    private String createTestPropertyFile(Properties p) throws Exception {
        String sTestDir = p.getProperty("harness.temp.directory");
        File ctsTempDir = new File(sTestDir);
        if (!ctsTempDir.exists() && !ctsTempDir.mkdirs()) {
            throw new Exception("Failed to create the testsuite's temporary working directory:  " + sTestDir);
        }
        String sJteFile = sTestDir + File.separator + "tstest.jte";
        try (FileOutputStream propsOut = null;){
            propsOut = new FileOutputStream(sJteFile);
            p.store(propsOut, null);
            String string = sJteFile;
            return string;
        }
    }

    private boolean isWindows() {
        return Os.isFamily((String)"windows");
    }

    private String formatPath(String classpath) {
        if (this.bIsRebuildableReverseTest) {
            classpath = classpath.replace("classes", "classes_vi_built");
        }
        try {
            String added = DeliverableFactory.getDeliverableInstance().getAdditionalClasspath(this.testDir);
            if (added != null) {
                if (!added.startsWith(File.pathSeparator)) {
                    classpath = classpath + File.pathSeparator;
                }
                classpath = classpath + added;
            }
        }
        catch (Exception e) {
            TestUtil.logHarness("Failed to get additional classpath for the following dist directory:  " + this.testDir);
        }
        if (this.isWindows()) {
            return Project.translatePath((String)classpath);
        }
        return classpath;
    }

    protected Status invokeCommand(String key) {
        Status s = null;
        try {
            String[] command = this.env.lookup("command." + key);
            String sClassPathFromExecProps = this.pExecProps.getProperty("clientClasspath", sClientClassesPath);
            TestUtil.logHarness("sClassPathFromExecProps = " + sClassPathFromExecProps);
            for (int ii = 0; ii < command.length; ++ii) {
                int iEqualsIndex;
                if (this.isWindows() && command[ii].toUpperCase().startsWith("PATH=")) {
                    iEqualsIndex = command[ii].indexOf("=");
                    String existingPath = command[ii].substring(iEqualsIndex + 1);
                    command[ii] = "PATH=" + Project.translatePath((String)existingPath);
                }
                if (command[ii].startsWith("CLASSPATH=")) {
                    iEqualsIndex = command[ii].indexOf("=");
                    String existingClassPath = command[ii].substring(iEqualsIndex + 1);
                    command[ii] = this.sVehicle.equals("ejbembed") ? "CLASSPATH=" + this.formatPath(existingClassPath) + File.pathSeparator + sClassPathFromExecProps : "CLASSPATH=" + sClassPathFromExecProps + File.pathSeparator + this.formatPath(existingClassPath);
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("new classpath = " + command[ii]);
                    }
                }
                if (command[ii].equals("-classpath")) {
                    command[ii + 1] = this.formatPath(command[ii + 1]) + File.pathSeparator + sClassPathFromExecProps;
                    if (TestUtil.harnessDebug) {
                        TestUtil.logHarnessDebug("new -classpath = " + command[ii]);
                    }
                }
                if (!command[ii].startsWith("-Dcom.sun.enterprise.iiop.security.interceptorFactory") || this.testDir.contains("csiv2")) continue;
                command[ii] = "-DNotInCSIV2=true";
            }
            if (command.length == 0) {
                return Status.error("environment `" + this.env.getName() + "' does not define a command `" + key + "'");
            }
            String className = command[0];
            String[] args = new String[command.length - 1];
            System.arraycopy(command, 1, args, 0, args.length);
            String basic = "command: " + className + " " + StringArray.join((String[])args);
            this.section.getMessageWriter().println(basic);
            s = this.invokeClass(className, args, this.logOut, this.logOut);
            return s;
        }
        catch (TestEnvironment.Fault e) {
            return Status.error("problem getting info in environment `" + this.env.getName() + "' for `command." + key + "'");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Status.error("An unexpected error occured in TSScript's invokeCommand method" + t.getMessage());
        }
    }

    private Status invokeClass(String className, String[] args, PrintWriter logOut, PrintWriter refOut) {
        Command testCommand;
        try {
            Class<?> c = Class.forName(className);
            testCommand = (Command)c.newInstance();
        }
        catch (ClassCastException e) {
            return Status.error("Can't run class `" + className + "': it does not implement interface " + Command.class.getName());
        }
        catch (ClassNotFoundException ex) {
            return Status.error("Can't find class `" + className + "', used in `" + this.env.getName() + "'");
        }
        catch (IllegalAccessException ex) {
            return Status.error("Illegal access to class `" + className + "', used in `" + this.env.getName() + "'");
        }
        catch (IllegalArgumentException ex) {
            return Status.error("Bad class name `" + className + "', used in `" + this.env.getName() + "'");
        }
        catch (InstantiationException ex) {
            return Status.error("Can't instantiate class `" + className + "', used in `" + this.env.getName() + "'");
        }
        catch (ThreadDeath e) {
            throw (ThreadDeath)e.fillInStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace(logOut);
            return Status.error("Unexpected exception trying to load command `" + className + "': " + e);
        }
        catch (Error e) {
            e.printStackTrace(logOut);
            return Status.error("Unexpected error trying to load command `" + className + "': " + e);
        }
        catch (Throwable e) {
            e.printStackTrace(logOut);
            return Status.error("Unexpected throwable trying to load command `" + className + "': " + e);
        }
        try {
            return testCommand.run(args, logOut, refOut);
        }
        catch (ThreadDeath e) {
            throw (ThreadDeath)e.fillInStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace(logOut);
            return Status.failed("Unexpected exception while executing command " + className + ": " + e);
        }
        catch (Error e) {
            e.printStackTrace(logOut);
            return Status.failed("Unexpected error while executing command " + className + ": " + e);
        }
        catch (Throwable e) {
            e.printStackTrace(logOut);
            return Status.error("Unexpected throwable while executing command " + className + ": " + e);
        }
    }

    static {
        bUseSameJVMCommand = Boolean.getBoolean("same.jvm");
    }

    public static class ClassFilter
    implements FilenameFilter {
        private static ClassFilter instance = new ClassFilter();

        private ClassFilter() {
        }

        public static ClassFilter getInstance() {
            return instance;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".class");
        }
    }
}

