/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.MimeTypeParseException;

import java.io.*;
import javax.activation.*;
import com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 

/**
 * We test this execption by invoking the two constructors for this class.
 * If they throw and we catch the expected execption then this testcase
 * passes, otherwise it fails. <p>
 */

public class MimeTypeParseException_Test extends MultiTest {

    String msg = "MimeType parse Exception caught!";

    // main
    public static void main(String[] args)
    {
	Test t = new MimeTypeParseException_Test(); 
	Status s = t.run(args, new PrintWriter(System.err, true), new PrintWriter(System.out, true)); 
	s.exit(); 
    }

    // Tests for equals:
    public Status testMimeTypeParseEx()
    {
	// We will call a method that always throws an
	// USDTE and look at the message

	try {
		// create MimeTypeParseException object
                MimeTypeParseException mtpe = new MimeTypeParseException();  // API TEST

                if( mtpe == null )
                    return Status.failed("Failed: to create MimeTypeParseException object");

	        this.throwMTPException();

	} catch(MimeTypeParseException e) {
	    // check the message and return
	    if(msg.equals(e.getMessage()))
		return Status.passed("MimeTypeParseException() test succeeded");
	    else
		return Status.failed("test failed: exception caught but wrong message returned.");
	}
	// if we didn't catch an exception something
	// went wrong, return failure

	return Status.failed("MimeTypeParseException() test failed to catch exception");
    }
    // stupid little method that always throws an exception.

    public void throwMTPException() throws MimeTypeParseException
    {
	// always throw and Exception when called
	if(true)
	   throw new MimeTypeParseException(msg);	// API TEST
    }
}
