/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeTypeParameterList;

import	java.beans.*;
import	java.io.*;
import	javax.activation.*;
import	java.net.*;
import	com.sun.javatest.*;
import com.sun.javatest.lib.MultiTest; 
import	java.awt.datatransfer.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/**
 * Create MimeTypeParameterList objects using constructors listed below: <p>
 *
 * TEST: MimeTypeParameterList();  <p>
 * TEST: MimeTypeParameterList(String);  <p>
 *
 * If this operation is successfull then this testcase passes, otherwise it fails.<p>
 */

public class MimeTypeParameterList_Test extends MultiTest
{

public static void main(String argv[])
{
	MimeTypeParameterList_Test lTest = new MimeTypeParameterList_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status mimeTypeParameterListTest()
{
	try {
		MimeTypeParameterList mtpl1 =  new MimeTypeParameterList();	// API TEST

		if( mtpl1 == null )
		    return Status.failed("Failed: to create MimeTypeParameterList object using default constructor");
	} catch(Exception ex) {
		return Status.failed("MimeType() threw " + ex.toString());
	}

        try {
              MimeTypeParameterList mtpl2 =  new MimeTypeParameterList(";charset=us-ascii;isoset=iso-9000;foo=abc");	// API TEST

                if( mtpl2 == null )
                    return Status.failed("Failed: to create MimeTypeParameterList object using constructor");
        } catch(Exception ex) {
                return Status.failed("MimeType(string) threw " + ex.toString());
        }

	return Status.passed("MimeTypeParameterList(void | String) test succeeded");
}

}
