/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.CommandMap;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/** CommandMap is an abstract class. The main functional testing is in the only
 *  provided concrete implementation, MailcapCommandMap, done separately. <p>
 *  We first get the default CommandMap object, then use it to get call the 
 *  getPreferredCommands() api with string parameter, if it returns a non-null
 *  CommandInfo array object then this testcase passes otherwise it fails.
 */

public class getPreferredCommands_Test implements Test
{
	public static void main(String argv[])
	{
		getPreferredCommands_Test lTest = new getPreferredCommands_Test();
		Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
		lStatus.exit();
	}

	public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
	{
		// does getDefaultCommandMap return a MailcapCommandMap?
		CommandMap lCommandMap = CommandMap.getDefaultCommandMap();

		if (!(lCommandMap instanceof MailcapCommandMap))
	    	    return Status.failed("getDefaultCommandMap() did not return MailcapCommandMap");
	
		CommandInfo[] comap = lCommandMap.getPreferredCommands("text/plain");	// API TEST

		if( comap == null )
		    return Status.failed("getPreferredCommands failed to return CommandInfo array!");

		return Status.passed("getPreferredCommands() Test succeeded");
	}
}
